(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.testModule = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var TestView = (function (_super) {
	    tslib.__extends(TestView, _super);
	    function TestView() {
	        var _this = _super.call(this) || this;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    TestView.prototype.setup = function () {
	        this.stageBg = new engine.Shape();
	        this.addChild(this.stageBg);
	        this.stageBg.beginFill(0x000000);
	        this.stageBg.drawRect(0, 0, engine.gameStage.width, engine.gameStage.height);
	        this.stageBg.endFill();
	        this.gameBg = new engine.Shape();
	        this.startBtn = new engine.Shape();
	        this.stageBg.addChild(this.startBtn);
	        this.startBtn.beginFill(0x66ccff);
	        this.startBtn.drawRect(0, 0, 200, 100);
	        this.startBtn.endFill();
	    };
	    return TestView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('pictures-start', _this.start, _this);
	        engine.globalEvent.addEventListener('pictures-stop', _this.stop, _this);
	        var testView = _this._testView = new TestView();
	        _this.addChild(testView);
	        return _this;
	    }
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	    };
	    GameWrapper.prototype.stop = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map