import {getTexture} from './utils'
export default class TestView extends engine.Container{
    worldTime:number;
    itemArr:engine.Sprite[]=[];//套圈物品图片组
    count:number = 8;//套圈物品个数
    itemPosArr:any[] = [{x:50,y:677},{x:272,y:704},{x:526,y:677},{x:58,y:496},{x:291,y:503},{x:521,y:488},{x:202,y:438},{x:434,y:440}]//套圈物品位置组
    itemSizeArr:any[] = [{w:158,h:213},{w:186,h:252},{w:158,h:216},{w:139,h:174},{w:154,h:206},{w:133,h:174},{w:93,h:128},{w:95,h:126}]//套圈物品大小组
    circle:engine.Image = null;//圈图片
    circleF:engine.Image = null;//前圈
    circleB:engine.Image = null;//后圈
    p1:engine.Point;//起点
    p2:engine.Point;//控制点
    p3:engine.Point;//终点
    falling:boolean = false;//环是否下降
    gameLayer1:engine.Sprite;
    gameLayer2:engine.Sprite;
    gameLayer3:engine.Sprite;
    paramT:number = 0; //贝塞尔曲线控制参数，范围0-1
    scaleChange:boolean = true;//环是否改变缩放大小
    fallingSpeed:number = 3;//环下降的速度
    rotateDir:number = 1;//环旋转方向
    rotateSpeed:number = 8;//环旋转速度
    targetPos:any = {x:0,y:0,w:0,h:0};//目标真实位置
    itemRotate:boolean = true;//物品是否旋转
    itemRotateDir:number = 1;//物品旋转方向
    isSetUp:boolean = false;
    constructor(){
        super()
        this.addEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
    }

    setup(){
        var that = this;
        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this)
        that.gameLayer1 = new engine.Sprite();
        that.addChild(that.gameLayer1);
        that.gameLayer2 = new engine.Sprite();
        that.addChild(that.gameLayer2);
        that.gameLayer3 = new engine.Sprite();
        that.addChild(that.gameLayer3);

        for(var i=0;i<that.count;i++){
            var item = new engine.Sprite(getTexture("dc9ef8c1-4c1d-469d-9f90-76a4082e4eb8"));
            that.gameLayer2.addChildAt(item,that.count-i);
            that.itemArr.push(item);
            item.width = that.itemSizeArr[i].w;
            item.height = that.itemSizeArr[i].h;
            item.anchorX = 186*0.5;
            item.anchorY = 252;
            item.x = that.itemPosArr[i].x-(186-item.width)*0.5;
            item.y = that.itemPosArr[i].y-(252-item.height);
        }

        that.circle = new engine.Image(getTexture("0b0b3bf3-78ae-494e-a52c-72e740bbe8f3"));
        that.gameLayer3.addChild(that.circle);
        that.circle.x = engine.gameStage.width*0.5-that.circle.width*0.5;
        that.circle.y = engine.gameStage.height-342+97+50;
        that.circle.mouseEnabled = false;
        that.circle.visible = false;
        console.log(that.circle.anchorX,that.circle.anchorY,that.circle.x,that.circle.y);

        that.circleF = new engine.Image(getTexture("bf7e0027-af98-4719-b682-2ca6edc22b37"));
        that.gameLayer3.addChild(that.circleF);
        that.circleF.visible = false;
        that.circleB = new engine.Image(getTexture("db69126a-a590-4092-b802-c862740dcf75"));
        that.gameLayer1.addChild(that.circleB);
        that.circleB.visible = false;
 
        that.p1 = new engine.Point(that.circle.x,that.circle.y);
        that.p2 = new engine.Point();
        that.p3 = new engine.Point();
        that.addEvnt();
    }

    addEvnt(){
        // this.circle.addEventListener(engine.MouseEvent.CLICK,this.startRing,this);
        this.addEventListener(engine.Event.ENTER_FRAME,this.updateGame,this);
        engine.globalEvent.addEventListener("pictures-reset",this.resetGame,this);
        engine.globalEvent.addEventListener("pictures-init",this.initGame,this);
        engine.globalEvent.addEventListener("pictures-hide",this.hideCircle,this);
        engine.globalEvent.addEventListener("pictures-startRing",this.startRing,this);
    }

    /**隐藏环 */
    hideCircle(){
        this.circle.visible = false;
    }

    /**初始化游戏 */
    initGame(){
        this.circle.mouseEnabled = true;
    }

    /**重置游戏 */
    resetGame(){
        var that = this;
        engine.Tween.removeTweens(that);
        that.paramT = 0;
        that.scaleChange = true;
        that.circle.scaleX = that.circle.scaleY = 1;
        that.circle.x = engine.gameStage.width*0.5-that.circle.width*0.5;
        that.circle.y = engine.gameStage.height-342+97+50;
        that.circle.visible = true;
        that.circleB.visible = that.circleF.visible = false;
        that.circleF.rotation = that.circleB.rotation = 0;
        that.itemRotate = true;
        that.circle.mouseEnabled = false;
        that.falling = false;
        that.itemRotate = true;
        
    }

    /**更新 */
    updateGame(){
        var that = this;
        if(that.falling){
            that.circleFalling();
        }
        if(that.itemRotate){
            that.updateItemRotate();
        }
    }

    /**更新物品旋转 */
    updateItemRotate(){
        var that = this;
        for(var i=0;i<that.itemArr.length;i++){
            that.itemArr[i].rotation += that.itemRotateDir * 0.3;
            if(i==(that.itemArr.length-1)&&(that.itemArr[i].rotation>=14||that.itemArr[i].rotation<=-14))
                that.itemRotateDir = -1 * that.itemRotateDir;
        }
    }

    /**开始套圈 */
    startRing(){
        var that = this;
        engine.globalEvent.dispatchEvent("pictures-start");
        that.circle.mouseEnabled = false;
        that.itemRotate = false;
        for(var i=0;i<that.itemArr.length;i++){
            that.itemArr[i].rotation = 0;
        }
        var index = Math.floor(Math.random()*that.count);
        that.targetPos.x = that.itemPosArr[index].x
        that.targetPos.y = that.itemPosArr[index].y
        that.targetPos.w = that.itemSizeArr[index].w;
        that.targetPos.h = that.itemSizeArr[index].h;
        that.p3.x = that.targetPos.x;
        that.p3.y = that.targetPos.y;
        that.p2.x = (that.p1.x+that.p3.x)*0.5+15;
        that.p2.y = (that.p1.y+that.p3.y)*0.7;
        engine.Tween.get(that,{onChange:that.curveMove,onChangeObj:that}).to({paramT:1},1000).call(()=>{
            that.setCricle();
        })
    }

    /**套中后设置环，前环，后环属性 */
    setCricle(){
        var that = this;
        that.circle.visible = false;
        that.circleF.visible = that.circleB.visible = true;
        that.circleF.scaleX = that.circleB.scaleX = that.circleF.scaleY = that.circleB.scaleY = that.circle.scaleX;
        that.circleF.anchorX = 316*0.5;
        that.circleB.anchorX = 316*0.5;
        that.circleB.anchorY = 69;
        that.circleF.x = that.targetPos.x-(316-that.circleF.width)*0.5;
        that.circleB.x = that.circleF.x;
        that.circleB.y = that.targetPos.y-69;
        that.circleF.y = that.targetPos.y;
        that.falling = true;
    }

    /**环下降 */
    circleFalling(){
        var that = this;
        var moveY = that.targetPos.y + that.targetPos.h - that.circleF.y-that.circleF.height;
        if(Math.abs(moveY)<=that.fallingSpeed){
            that.circleF.rotation = that.circleB.rotation = 0;
            that.falling = false;
            engine.globalEvent.dispatchEvent("pictures-end"); 
            return;
        }else{
            that.circleB.y += that.fallingSpeed;
            that.circleF.y += that.fallingSpeed;
            that.circleB.rotation += that.rotateDir * that.rotateSpeed;
            that.circleF.rotation += that.rotateDir * that.rotateSpeed;
            if(that.circleF.rotation>=45||that.circleF.rotation<=(-45)){
                that.rotateDir = that.rotateDir*-1;
            }
        }
        
    }

    /**贝塞尔曲线移动，曲线公式:f=(1-t)*(1-t)*p0+2*t*(1-t)*p1+t*t*p2 */
    curveMove(){
        var that = this
        var t = that.paramT;
        that.circle.x = (1-t)*(1-t)*that.p1.x+2*t*(1-t)*that.p2.x+t*t*that.p3.x;
        that.circle.y = (1-t)*(1-t)*that.p1.y+2*t*(1-t)*that.p2.y+t*t*that.p3.y;
        if(that.circle.y<=that.p2.y&&that.scaleChange){
            var targtScale = that.setScale(that.circle);
            var targtDur = 1000 - t*1000;
            engine.Tween.get(that.circle).to({scaleX:targtScale,scaleY:targtScale},targtDur);
            that.scaleChange = false;
        }
    }

    /**设置缩放 */
    setScale(targt:engine.Image):number{
        return this.targetPos.w/targt.width;
    }
}