(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.taoQuan = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}

	var TestView = (function (_super) {
	    tslib.__extends(TestView, _super);
	    function TestView() {
	        var _this = _super.call(this) || this;
	        _this.itemArr = [];
	        _this.count = 8;
	        _this.itemPosArr = [{ x: 50, y: 677 }, { x: 272, y: 704 }, { x: 526, y: 677 }, { x: 58, y: 496 }, { x: 291, y: 503 }, { x: 521, y: 488 }, { x: 202, y: 438 }, { x: 434, y: 440 }];
	        _this.itemSizeArr = [{ w: 158, h: 213 }, { w: 186, h: 252 }, { w: 158, h: 216 }, { w: 139, h: 174 }, { w: 154, h: 206 }, { w: 133, h: 174 }, { w: 93, h: 128 }, { w: 95, h: 126 }];
	        _this.circle = null;
	        _this.circleF = null;
	        _this.circleB = null;
	        _this.falling = false;
	        _this.paramT = 0;
	        _this.scaleChange = true;
	        _this.fallingSpeed = 3;
	        _this.rotateDir = 1;
	        _this.rotateSpeed = 8;
	        _this.targetPos = { x: 0, y: 0, w: 0, h: 0 };
	        _this.itemRotate = true;
	        _this.itemRotateDir = 1;
	        _this.isSetUp = false;
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    TestView.prototype.setup = function () {
	        var that = this;
	        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
	        that.gameLayer1 = new engine.Sprite();
	        that.addChild(that.gameLayer1);
	        that.gameLayer2 = new engine.Sprite();
	        that.addChild(that.gameLayer2);
	        that.gameLayer3 = new engine.Sprite();
	        that.addChild(that.gameLayer3);
	        for (var i = 0; i < that.count; i++) {
	            var item = new engine.Sprite(getTexture("dc9ef8c1-4c1d-469d-9f90-76a4082e4eb8"));
	            that.gameLayer2.addChildAt(item, that.count - i);
	            that.itemArr.push(item);
	            item.width = that.itemSizeArr[i].w;
	            item.height = that.itemSizeArr[i].h;
	            item.anchorX = 186 * 0.5;
	            item.anchorY = 252;
	            item.x = that.itemPosArr[i].x - (186 - item.width) * 0.5;
	            item.y = that.itemPosArr[i].y - (252 - item.height);
	        }
	        that.circle = new engine.Image(getTexture("0b0b3bf3-78ae-494e-a52c-72e740bbe8f3"));
	        that.gameLayer3.addChild(that.circle);
	        that.circle.x = engine.gameStage.width * 0.5 - that.circle.width * 0.5;
	        that.circle.y = engine.gameStage.height - 342 + 97 + 50;
	        that.circle.mouseEnabled = false;
	        that.circle.visible = false;
	        console.log(that.circle.anchorX, that.circle.anchorY, that.circle.x, that.circle.y);
	        that.circleF = new engine.Image(getTexture("bf7e0027-af98-4719-b682-2ca6edc22b37"));
	        that.gameLayer3.addChild(that.circleF);
	        that.circleF.visible = false;
	        that.circleB = new engine.Image(getTexture("db69126a-a590-4092-b802-c862740dcf75"));
	        that.gameLayer1.addChild(that.circleB);
	        that.circleB.visible = false;
	        that.p1 = new engine.Point(that.circle.x, that.circle.y);
	        that.p2 = new engine.Point();
	        that.p3 = new engine.Point();
	        that.addEvnt();
	    };
	    TestView.prototype.addEvnt = function () {
	        this.addEventListener(engine.Event.ENTER_FRAME, this.updateGame, this);
	        engine.globalEvent.addEventListener("pictures-reset", this.resetGame, this);
	        engine.globalEvent.addEventListener("pictures-init", this.initGame, this);
	        engine.globalEvent.addEventListener("pictures-hide", this.hideCircle, this);
	        engine.globalEvent.addEventListener("pictures-startRing", this.startRing, this);
	    };
	    TestView.prototype.hideCircle = function () {
	        this.circle.visible = false;
	    };
	    TestView.prototype.initGame = function () {
	        this.circle.mouseEnabled = true;
	    };
	    TestView.prototype.resetGame = function () {
	        var that = this;
	        engine.Tween.removeTweens(that);
	        that.paramT = 0;
	        that.scaleChange = true;
	        that.circle.scaleX = that.circle.scaleY = 1;
	        that.circle.x = engine.gameStage.width * 0.5 - that.circle.width * 0.5;
	        that.circle.y = engine.gameStage.height - 342 + 97 + 50;
	        that.circle.visible = true;
	        that.circleB.visible = that.circleF.visible = false;
	        that.circleF.rotation = that.circleB.rotation = 0;
	        that.itemRotate = true;
	        that.circle.mouseEnabled = false;
	        that.falling = false;
	        that.itemRotate = true;
	    };
	    TestView.prototype.updateGame = function () {
	        var that = this;
	        if (that.falling) {
	            that.circleFalling();
	        }
	        if (that.itemRotate) {
	            that.updateItemRotate();
	        }
	    };
	    TestView.prototype.updateItemRotate = function () {
	        var that = this;
	        for (var i = 0; i < that.itemArr.length; i++) {
	            that.itemArr[i].rotation += that.itemRotateDir * 0.3;
	            if (i == (that.itemArr.length - 1) && (that.itemArr[i].rotation >= 14 || that.itemArr[i].rotation <= -14))
	                that.itemRotateDir = -1 * that.itemRotateDir;
	        }
	    };
	    TestView.prototype.startRing = function () {
	        var that = this;
	        engine.globalEvent.dispatchEvent("pictures-start");
	        that.circle.mouseEnabled = false;
	        that.itemRotate = false;
	        for (var i = 0; i < that.itemArr.length; i++) {
	            that.itemArr[i].rotation = 0;
	        }
	        var index = Math.floor(Math.random() * that.count);
	        that.targetPos.x = that.itemPosArr[index].x;
	        that.targetPos.y = that.itemPosArr[index].y;
	        that.targetPos.w = that.itemSizeArr[index].w;
	        that.targetPos.h = that.itemSizeArr[index].h;
	        that.p3.x = that.targetPos.x;
	        that.p3.y = that.targetPos.y;
	        that.p2.x = (that.p1.x + that.p3.x) * 0.5 + 15;
	        that.p2.y = (that.p1.y + that.p3.y) * 0.7;
	        engine.Tween.get(that, { onChange: that.curveMove, onChangeObj: that }).to({ paramT: 1 }, 1000).call(function () {
	            that.setCricle();
	        });
	    };
	    TestView.prototype.setCricle = function () {
	        var that = this;
	        that.circle.visible = false;
	        that.circleF.visible = that.circleB.visible = true;
	        that.circleF.scaleX = that.circleB.scaleX = that.circleF.scaleY = that.circleB.scaleY = that.circle.scaleX;
	        that.circleF.anchorX = 316 * 0.5;
	        that.circleB.anchorX = 316 * 0.5;
	        that.circleB.anchorY = 69;
	        that.circleF.x = that.targetPos.x - (316 - that.circleF.width) * 0.5;
	        that.circleB.x = that.circleF.x;
	        that.circleB.y = that.targetPos.y - 69;
	        that.circleF.y = that.targetPos.y;
	        that.falling = true;
	    };
	    TestView.prototype.circleFalling = function () {
	        var that = this;
	        var moveY = that.targetPos.y + that.targetPos.h - that.circleF.y - that.circleF.height;
	        if (Math.abs(moveY) <= that.fallingSpeed) {
	            that.circleF.rotation = that.circleB.rotation = 0;
	            that.falling = false;
	            engine.globalEvent.dispatchEvent("pictures-end");
	            return;
	        }
	        else {
	            that.circleB.y += that.fallingSpeed;
	            that.circleF.y += that.fallingSpeed;
	            that.circleB.rotation += that.rotateDir * that.rotateSpeed;
	            that.circleF.rotation += that.rotateDir * that.rotateSpeed;
	            if (that.circleF.rotation >= 45 || that.circleF.rotation <= (-45)) {
	                that.rotateDir = that.rotateDir * -1;
	            }
	        }
	    };
	    TestView.prototype.curveMove = function () {
	        var that = this;
	        var t = that.paramT;
	        that.circle.x = (1 - t) * (1 - t) * that.p1.x + 2 * t * (1 - t) * that.p2.x + t * t * that.p3.x;
	        that.circle.y = (1 - t) * (1 - t) * that.p1.y + 2 * t * (1 - t) * that.p2.y + t * t * that.p3.y;
	        if (that.circle.y <= that.p2.y && that.scaleChange) {
	            var targtScale = that.setScale(that.circle);
	            var targtDur = 1000 - t * 1000;
	            engine.Tween.get(that.circle).to({ scaleX: targtScale, scaleY: targtScale }, targtDur);
	            that.scaleChange = false;
	        }
	    };
	    TestView.prototype.setScale = function (targt) {
	        return this.targetPos.w / targt.width;
	    };
	    return TestView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        var testView = _this._testView = new TestView();
	        _this.addChild(testView);
	        return _this;
	    }
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	    };
	    GameWrapper.prototype.stop = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}

	return index;

})));

//# sourceMappingURL=main.js.map