export enum SoundType {
    click = 'click',
    bounce = 'bounce',
    good = 'good',
    recover = 'recover',
    shoot = 'shoot',
}
import Body from "./physics/Body";
import { LADDER_START, LADDER_END, LADDER_NUMS, LADDER_H_START, LADDER_H_END, LADDER_H_NUMS } from "./gameconsts";
export const isSpecialBody = (body: Body) => {
    return body.type != 'circle' && body.type != 'square' && body.type != 'regTriangle'
}

export const isSpecialCircle = (body: Body)=>{
    return body.type ==='specialCircle'
}

const ladderHeight = LADDER_END - LADDER_START;
export const getLadderPosition = (i: number) => {
    return ladderHeight / LADDER_NUMS * i + LADDER_START;
}
const ladderWidth = LADDER_H_END - LADDER_H_START;
export const getLadderHPosition = (i: number) => {
    return ladderWidth / LADDER_H_NUMS * i + LADDER_H_START;
}

export const getLadderGap = ()=>{
    return ladderHeight / LADDER_NUMS
}

export const getBounce = () => {
    return 0.9 + Math.random() * 0.09;
}

export const shuffle = (array) => {
    const _array = array.concat();

    for (let i = _array.length; i--;) {
        const j = Math.floor(Math.random() * (i + 1));
        const temp = _array[i];
        _array[i] = _array[j];
        _array[j] = temp;
    }

    return _array;
}

export function getTexture(uuid) {
	return engine.Texture.from(getAssetByUUID(uuid).uuid);
}

export function getTextureByName(name) {
	return getTexture(engine.getAssetByName(name).uuid);
}

export function playSound(name) {
	return;
	engine.playSound(engine.getAssetByName(name).uuid, {keep: true});
}
export function createSvga(name, anchorName?) {
	let inst = new svga.Svga();
	inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	return inst;
}