// tslint:disable:only-arrow-functions
// tslint:disable:no-conditional-assignment
// tslint:disable:prefer-const
// tslint:disable:no-var-keyword
// tslint:disable:no-inferrable-types
import { Vector } from "./Vector";
import { Tween } from "../tween/Tween";
import Body from "./Body";
export class Circle extends Body {
    public type = "circle";
    public view;
    public radius;

    _num;

    _x = 0;
    _y = 0;

    constructor(radius, view) {
        super();
        this.radius = radius;
        this.view = view;
    }

    get x() {
        return this._x;
    }

    set x(value) {
        if (this._x != value) {
            this._x = value;
            this.view.x = value;
        }
    }

    get y() {
        return this._y;
    }

    set y(value) {
        if (this._y != value) {
            this._y = value;
            this.view.y = value;
        }
    }

    get num() {
        return this._num;
    }

    set num(value) {
        if (this._num != value) {
            this._num = value;
            // console.log("圆形value",value);
            this.view.txt&&(this.view.txt.text = value||2+"");
        }
    }
    //新增，矫正偏移
    get _viewx(){
        return this.view.x;//+this.view.anchorX;
    }
    get _viewy(){
        return this.view.y;//+this.view.anchorY;
    }

    public shake() {
        var startx = -this.view.bg.anchorX;
        var starty = -this.view.bg.anchorY;
        this.view.bg.x = startx;
        this.view.bg.y = starty;

        Tween.to(this.view.bg, 1, {
            x: startx+3,
            y:  starty+3,
            yoyo: 2,
            useFrame: true,
            onComplete: function () {
                console.log("circle震动3-------",this.view.bg.x,this.view.bg.y);
            }

        })
    }

    collideBall(ball) {
        var ballax = ball._viewx;
        var ballay = ball._viewy;

        var thisax = this._viewx;
        var thisay = this._viewy;

        var deltaX = ballax - thisax;
        var deltaY = ballay - thisay;
        //碰撞

        if (deltaX * deltaX + deltaY * deltaY < (this.radius + ball.radius)*(this.radius + ball.radius)) {
            var velocity = ball.velocity.clone();
            var deta = Math.floor(velocity.length() / ball.radius)+5    //deta就是插值数量,如为0，则直接取上一帧的法向量
            var speedX = velocity.x / (deta + 1);
            var speedY = velocity.y / (deta + 1);
            for (var i = 0; i <= deta; i++) {
                var normal = this.nearestCollideNormal({ x: ballax - speedX * (i + 1), y: ballay - speedY * (i + 1) }, ball, deta + 1, i + 1)
                if (normal) {
                    return normal
                }
            }
        } else {
            return false
            //提前给出要碰撞的法向量
            // return new Vector(deltaX,deltaY).cross();
        }
    }

    private nearestCollideNormal(position, ball, deta, i) {
        var thisax = this._viewx;
        var thisay = this._viewy;

        var deltaX = position.x-thisax ;
        var deltaY = position.y-thisay;
        if (deltaX * deltaX + deltaY * deltaY < (this.radius + ball.radius)*(this.radius + ball.radius)) {
            return false;
        } else {
            //直接更改球的位置为最接近碰撞的位置
            ball.view.x -= ball.velocity.x / deta * i;
            ball.view.y -= ball.velocity.y / deta * i;
            //提前给出要碰撞的法向量
            return new Vector(deltaX, deltaY).cross();
        }
    }

}