import { injectProps } from "../props";
import PlayScene from "./PlayScene";

export class gameWrapper extends engine.Container{
    private _status;
	private _gameView: PlayScene;

	constructor() {
		super();
		engine.globalEvent.addEventListener("game-reset", this.reset, this);
        engine.globalEvent.addEventListener("game-start", this.start, this);
        engine.globalEvent.addEventListener("game-pause", this.pause, this);
        engine.globalEvent.addEventListener("game-resume", this.resume, this);

		this.addEventListener(engine.MouseEvent.CLICK, this.onTap, this);
		// console.log("测试wrapper");
		// try{
		// 	console.log("wrapper-init",getAssetByUUID("fc8ca082-90b7-4c22-85cf-9165ffaf47bf"));
		// }catch(err){
		// 	console.error("资源问题",err);
		// }
		
		// gameView.reset()
		// gameView.start()
	}

	
	reset(event: engine.Event) {		
		injectProps(event.data);
		console.log("game-reset");
		if(!this._gameView){
			this._gameView = new PlayScene();
			this.addChild(this._gameView);
		}
		
		this._gameView.visible = true;
		this._gameView.reset();
	}

	start(event: engine.Event) {
		injectProps(event.data);
		console.log("game-start");
		this._status = 1;
		this._gameView.start();
	}

	pause() {
		console.log("game-pause");
		this._gameView.pausegame();
	}

	resume() {
		console.log("game-resume");
		this._gameView.resumegame();
	}

	// revive() {
	// 	this._gameView.revive();
	// }

	clear() {
		this._gameView.visible = false;
	}

	private onTap(event) {
	//	this._gameView.tap(event);
	}
}