import { Square } from "../physics/Square";
import PlayScene from "../PlayScene";
import { getTextureByName } from "../utils";

export default (that: PlayScene, x, y, num) => {
    const picType = Math.ceil(Math.random() * 4);
    const pic = new engine.Sprite(getTextureByName(`sq${picType}`));
    pic.anchorX = pic.width / 2;
    pic.anchorY = pic.height / 2;
    let block: Square = that.pool.takeOut("square");
    //位置偏移
    var anchorx = pic.width/2;
    var anchory = pic.height/2;
    if (!block) {
        const sprite = new engine.Sprite();
        sprite.mouseEnabled = sprite.mouseChildren = false;
        //背景
        const length = pic.width;
        sprite["bg"] = pic;
        sprite.addChild(pic);
        pic.x = -anchorx;
        pic.y = -anchory;
        //数字
        const txt = new engine.TextField();
        txt.width = length;
        txt.height = pic.height;
        txt.anchorX = length / 2;
        txt.anchorY = pic.height / 2;
        txt.size = 30;
        txt.fillColor = 0xffffff;
        txt.textAlign = engine.TEXT_ALIGN.CENTER;
        txt.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
        sprite["txt"] = txt;
        sprite.addChild(txt);
        txt.x = -anchorx;
        txt.y = -anchory;

        // that.view.addChild(sprite)
        block = new Square(length, sprite);
    }
    //初始化
    else {
        if (block.view["bg"]) {
            block.view.removeChild(block.view["bg"]);
            block.view["bg"] = pic;
            block.view.addChild(pic);
            block.view.addChild(block.view['txt']);

            pic.x = -anchorx;
            pic.y = -anchory;
            block.view['txt'].x = -anchorx;
            block.view['txt'].y = -anchory;
        }
    }
    engine.Tween.removeTweens(block.view);

    block.view["bg"]['__resName__'] = `sq${picType}`;
    that.addChild(block.view)
    // console.log("方形偏移",anchorx,anchory);
    block.x = x;
    block.y = y;
    block.num = num;
    block.rotation = Math.random() * 360;
    // block.rotation = Math.random()>0.5 ? 0 : 45;
    that.blocks.push(block);
    block.ladderNums = 1;
}