import { Circle } from "../physics/Circle";
import PlayScene from "../PlayScene";
import { getTextureByName } from "../utils";

export default (that: PlayScene, x, y, num) => {
    let block: Circle = that.pool.takeOut("specialCircle");
    const radius = (getTextureByName('+1') as engine.Texture).orig.width / 2;
    const length = radius * 2;
    if (!block) {
        const sprite = new engine.Sprite();
        sprite.mouseEnabled = sprite.mouseChildren = false;
        //背景
        const shape = new engine.Sprite(getTextureByName('+1'));
        shape.anchorX = shape.width / 2;
        shape.anchorY = shape.height / 2;
        sprite["bg"] = shape;
        sprite.addChild(shape);
        shape.x = -shape.width/2;
        shape.y = -shape.height/2;

        block = new Circle(radius, sprite);
        block.type = 'specialCircle';
    } else {
        if (block.radius != radius) {
            block.view.bg.clear();
            block.view.bg.beginFill(0xcccccc);
            block.view.bg.drawCircle(0, 0, radius);
            block.view.bg.endFill();
        }
    }
    engine.Tween.removeTweens(block.view);
    that.addChild(block.view)
    block.x = x;
    block.y = y;

    block.num = num;
    that.blocks.push(block);
    block.ladderNums = 1;
}