import { sqrt3 } from "../physics/Const";
import { RegTriangle } from "../physics/RegTriangle";
import PlayScene from "../PlayScene";
import { BALL_D } from "../gameconsts";

export default (that: PlayScene, x, y, length, rotation, key = 'specialRegTriangle') => {
    let block: RegTriangle;

    const sprite = new engine.Sprite();
    sprite.visible = false;//window['debugPhysics'];
    sprite.alpha = 0.7;
    sprite.mouseEnabled = sprite.mouseChildren = false;
    // console.log("显示",window['debugPhysics'])
    //背景
    const shape = new engine.Shape();

    shape.beginFill(0xcccccc);
    shape.moveTo(0, -length * sqrt3 / 3);
    shape.lineTo(length / 2, length * sqrt3 / 6);
    shape.lineTo(-length / 2, length * sqrt3 / 6);
    shape.endFill();
    sprite["bg"] = shape;
    sprite.addChild(shape);
    //数字
    const txt = new engine.TextField();
    txt.width = length;
    txt.height = length;
    txt.anchorX = length / 2;
    txt.anchorY = length / 2;
    txt.size = 25;
    txt.fillColor = 0xffffff;
    txt.textAlign = engine.TEXT_ALIGN.CENTER;
    txt.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
    
    sprite["txt"] = txt;
    sprite.addChild(txt);
    block = new RegTriangle(length, sprite);
    block.type = key;

    that.addChild(block.view);
    //误差处理
    block.x = x-BALL_D/2;
    block.y = y-BALL_D/2;
    block.rotation = rotation;
    // block.num = num
    that.blocks.push(block);
}