import { RegTriangle } from "../physics/RegTriangle";
import PlayScene from "../PlayScene";
import { getTextureByName } from "../utils";

export default (that: PlayScene, x, y, num) => {
    let block = that.pool.takeOut("regTriangle");
    const picType = Math.ceil(Math.random() * 2);
    const pic = new engine.Sprite(getTextureByName(`tri${picType}`));
    pic.anchorX = pic.width / 2;
    pic.anchorY = pic.height/2;// * .65;

    //位置偏移
    var anchorx = 0;
    var anchory = 0;
    anchorx = pic.width/2;
    anchory = pic.height/2;//*0.65;
    if (!block) {
        const sprite = new engine.Sprite();
        sprite.mouseEnabled = sprite.mouseChildren = false;
        //背景
        const length = pic.width;
        const height = pic.height;
        // console.log("三角形的文字偏移",pic.width,pic.height);
        sprite["bg"] = pic;
        sprite.addChild(pic);
        pic.x = -anchorx;
        pic.y = -anchory;
        //数字
        const txt = new engine.TextField();
        txt.width = length;
        txt.height = height;
        txt.anchorX = length / 2;
        txt.anchorY = height /2;//*0.65;
        
        txt.size = 26;
        txt.fillColor = 0xffffff;
        txt.textAlign = engine.TEXT_ALIGN.CENTER;
        txt.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
        sprite["txt"] = txt;
        sprite.addChild(txt);
        txt.x = -anchorx;
        txt.y = -anchory+(anchorx-anchory)*2;

        block = new RegTriangle(length, sprite);
    } else {
        if (block.view["bg"]) {
            block.view.removeChild(block.view["bg"]);
            block.view["bg"] = pic;
            block.view.addChild(pic);
            block.view.addChild(block.view['txt']);

            pic.x = -anchorx;
            pic.y = -anchory;
            block.view['txt'].x = -anchorx;
            block.view['txt'].y = -anchory+(anchorx-anchory)*2;
        }
    }
    engine.Tween.removeTweens(block.view);
    block.view["bg"]['__resName__'] = `tri${picType}`;
    that.addChild(block.view)
    block.x = x;
    block.y = y;
    // console.log("三角形偏移",anchorx,anchory);
    block.rotation = Math.random() * 360;
    block.num = num;
    that.blocks.push(block);
    block.ladderNums = 1;
}