import { Circle } from "../physics/Circle";
import PlayScene from "../PlayScene";
import { getTextureByName } from "../utils";

export default (that: PlayScene, x, y, num) => {
    let block = that.pool.takeOut("circle");

    //位置偏移
    var anchorx = 0;
    var anchory = 0;
    if (!block) {
        const sprite = new engine.Sprite();
        sprite.mouseEnabled = sprite.mouseChildren = false;
        //背景
        const shape = new engine.Image(getTextureByName('circle1'));
        shape['__resName__'] = 'circle1';
        const radius = shape.width / 2;
        const length = radius * 2;
        shape.anchorX = shape.width / 2;
        shape.anchorY = shape.height / 2;

        anchorx = radius;
        anchory = radius;

        sprite["bg"] = shape;
        sprite.addChild(shape);
        shape.x = -anchorx;
        shape.y = -anchory;
        //数字
        const txt = new engine.TextField();
        txt.width = length;
        txt.height = length;
        txt.anchorX = length / 2;
        txt.anchorY = length / 2;

        txt.size = 30;
        txt.fillColor = 0xffffff;
        txt.textAlign = engine.TEXT_ALIGN.CENTER;
        txt.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
        sprite["txt"] = txt;
        sprite.addChild(txt);
        txt.x = -anchorx;
        txt.y = -anchory;

        block = new Circle(radius, sprite);
    }
    engine.Tween.removeTweens(block.view);

    that.addChild(block.view)
    block.x = x;
    block.y = y;
    // console.log("圆形偏移",anchorx,anchory);
    block.num = num;
    that.blocks.push(block);
    block.ladderNums = 1;
}