import Body from "./physics/Body";
import { sqrt3 } from "./physics/Const";
export default class Effect {
    NUMS_MAX = 11;
    _parent: engine.Container;
    constructor(block: Body, parent: engine.Container) {
        const resName = block.view['bg']['__resName__']
        for (let i = 0; i < this.NUMS_MAX; i++) {
            const data = this.createItem(resName);
            parent.addChild(data.shape);
            data.shape.x = block.x;
            data.shape.y = block.y;
            engine.Tween.get(data.shape).to({ x: data.targetX + block.x, y: block.y + data.targetY, scaleY: 0, scaleX: 0 }, 360).call(() => {
                data.shape.parent && data.shape.parent.removeChild(data.shape);
            });
        }
    }

    createItem(resName: string) {
        const moveDisMax = 100;
        const squareSize = 100;
        const shape = new engine.Shape();
        const shapeType = this.getShapeType(resName);
        if (shapeType == 'circle') {
            shape.beginFill(this.getShapeColor(resName));
            shape.drawCircle(0, 0, squareSize / 2);
            shape.endFill();
        } else if (shapeType == 'tri') {
            shape.beginFill(this.getShapeColor(resName));
            shape.moveTo(0, -squareSize * sqrt3 / 3);
            shape.lineTo(squareSize / 2, squareSize * sqrt3 / 6);
            shape.lineTo(-squareSize / 2, squareSize * sqrt3 / 6);
            shape.endFill();
        } else if (shapeType == 'sq') {
            shape.beginFill(this.getShapeColor(resName));
            shape.drawRect(-squareSize / 2, -squareSize / 2, squareSize, squareSize);
            shape.endFill();
        }

        const scale = Math.random() * 0.7 + 0.3;
        const rotation = Math.random() * 360;
        const angle = Math.random() * Math.PI * 2;
        const dis = moveDisMax / 2 + moveDisMax / 2 * Math.random();
        const targetX = Math.sin(angle) * dis;
        const targetY = Math.cos(angle) * dis;
        shape.scaleX = shape.scaleY = scale;
        shape.rotation = rotation;
        return { shape: shape, targetX: targetX, targetY: targetY };
    }

    getShapeType(resName: string) {
        if (resName == 'circle1')
            return 'circle';
        if (resName.indexOf('tri') > -1)
            return 'tri';
        if (resName.indexOf('sq') > -1)
            return 'sq';
        return 'circle'
    }

    getShapeColor(resName: string) {
        if (resName == 'circle1')
            return 0xffca55;
        if (resName == 'sq1')
            return 0xfa7782;
        if (resName == 'sq2')
            return 0xf677ce;
        if (resName == 'sq3')
            return 0xffac84;
        if (resName == 'sq4')
            return 0xffca55;
        if (resName == 'tri1')
            return 0x2db0ee;
        if (resName == 'tri2')
            return 0x86e45f;
        return 0xffca55

    }
}