(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.tanqiu = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}

	var BALL_D = 34;
	var LEFT_GROUND = 80;
	var RIGHT_GROUND = 675;
	var LADDER_START = 350 - 100;
	var LADDER_END = 1150;
	var LADDER_NUMS = 10;
	var LADDER_H_START = 130;
	var LADDER_H_END = 710;
	var LADDER_H_NUMS = 7;
	var ACELE_DELAY = 4000;

	var SoundType;
	(function (SoundType) {
	    SoundType["click"] = "click";
	    SoundType["bounce"] = "bounce";
	    SoundType["good"] = "good";
	    SoundType["recover"] = "recover";
	    SoundType["shoot"] = "shoot";
	})(SoundType || (SoundType = {}));
	var isSpecialBody = function (body) {
	    return body.type != 'circle' && body.type != 'square' && body.type != 'regTriangle';
	};
	var isSpecialCircle = function (body) {
	    return body.type === 'specialCircle';
	};
	var ladderHeight = LADDER_END - LADDER_START;
	var getLadderPosition = function (i) {
	    return ladderHeight / LADDER_NUMS * i + LADDER_START;
	};
	var ladderWidth = LADDER_H_END - LADDER_H_START;
	var getLadderHPosition = function (i) {
	    return ladderWidth / LADDER_H_NUMS * i + LADDER_H_START;
	};
	var getLadderGap = function () {
	    return ladderHeight / LADDER_NUMS;
	};
	var getBounce = function () {
	    return 0.9 + Math.random() * 0.09;
	};
	var shuffle = function (array) {
	    var _array = array.concat();
	    for (var i = _array.length; i--;) {
	        var j = Math.floor(Math.random() * (i + 1));
	        var temp = _array[i];
	        _array[i] = _array[j];
	        _array[j] = temp;
	    }
	    return _array;
	};
	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function playSound(name) {
	    return;
	}

	var counter;
	var resetCounter = function () {
	    counter = 1;
	};
	var getBlockShape = function () {
	    var list = shuffle([1, 2, 3]);
	    return list[0];
	};
	var random = function (start, end) {
	    return start + (end - start) * Math.random();
	};
	var getNums = function (currBallNums) {
	    return Math.ceil(currBallNums * random(1 * window['numsP'], 3.5 * window['numsP']));
	};
	var getNums2 = function (currBallNums) {
	    return Math.ceil(currBallNums * random(4 * window['numsP'], 7 * window['numsP']));
	};
	var getSpecialNumBlocksNums = function (currBallNums) {
	    if (currBallNums < 20)
	        return 1;
	    if (currBallNums < 50)
	        return 2;
	    return 3;
	};
	var getBlocks = function (currBallNums) {
	    var blockNums = Math.random() > 0.3 ? 3 : 2;
	    var specialBall = 0;
	    if (counter % 3 === 0) {
	        specialBall = 1;
	    }
	    var list = [];
	    for (var i = 0; i < LADDER_H_NUMS; i++) {
	        list.push(i);
	    }
	    list = shuffle(list);
	    var blockPositions = list.slice(0, blockNums);
	    var specialBallPosition = list[list.length - 1];
	    var blocksInfo = [];
	    for (var j = 0; j < blockPositions.length; j++) {
	        var p = blockPositions[j];
	        var nums = getNums(currBallNums);
	        var specialNumBlocksNums = getSpecialNumBlocksNums(currBallNums);
	        if (Math.random() < 0.3 && j < specialNumBlocksNums) {
	            nums = getNums2(currBallNums);
	        }
	        if (currBallNums >= 50)
	            nums = getNums2(currBallNums);
	        blocksInfo.push({
	            position: p,
	            type: getBlockShape(),
	            nums: nums || 2
	        });
	    }
	    counter++;
	    return {
	        blocksInfo: blocksInfo,
	        specialBallPosition: specialBall ? specialBallPosition : -1
	    };
	};

	var Vector = (function () {
	    function Vector(x, y) {
	        if (x === void 0) { x = 0; }
	        if (y === void 0) { y = 0; }
	        this.x = x;
	        this.y = y;
	    }
	    Vector.prototype.initialize = function () {
	        this.x = 0;
	        this.y = 0;
	    };
	    Vector.prototype.length = function () {
	        return Math.sqrt(this.length2());
	    };
	    Vector.prototype.length2 = function () {
	        return this.x * this.x + this.y * this.y;
	    };
	    Vector.prototype.symmetricFromNormalVector = function (normalVector) {
	        var nx2 = normalVector.x * normalVector.x;
	        var ny2 = normalVector.y * normalVector.y;
	        var nxy = normalVector.x * normalVector.y;
	        var tempx = this.x;
	        this.x = (2 * this.y * nxy + this.x * (nx2 - ny2)) / (nx2 + ny2);
	        this.y = (2 * tempx * nxy - this.y * (nx2 - ny2)) / (nx2 + ny2);
	        return this;
	    };
	    Vector.prototype.rotate = function (angle) {
	        var tempx = this.x;
	        this.x = this.x * Math.cos(angle) - this.y * Math.sin(angle);
	        this.y = this.y * Math.cos(angle) + tempx * Math.sin(angle);
	        return this;
	    };
	    Vector.prototype.clone = function () {
	        return new Vector(this.x, this.y);
	    };
	    Vector.prototype.translate = function (x, y) {
	        this.x += x;
	        this.y += y;
	        return this;
	    };
	    Vector.prototype.cross = function () {
	        if (this.x == 0) {
	            if (this.y == 0) ;
	            else {
	                this.x = 1;
	                this.y = 0;
	            }
	        }
	        else {
	            if (this.y == 0) {
	                this.x = 0;
	                this.y = 1;
	            }
	            else {
	                var tempx = this.x;
	                this.x = 1;
	                this.y = -tempx / this.y;
	            }
	        }
	        return this;
	    };
	    Vector.prototype.getMagnitude = function () {
	        return Math.sqrt(Math.pow(this.x, 2) + Math.pow(this.y, 2));
	    };
	    Vector.prototype.add = function (anotherVector) {
	        var v = new Vector();
	        v.x = this.x + anotherVector.x;
	        v.y = this.y + anotherVector.y;
	        return v;
	    };
	    Vector.prototype.subtract = function (anotherVector) {
	        var v = new Vector();
	        v.x = this.x - anotherVector.x;
	        v.y = this.y - anotherVector.y;
	        return v;
	    };
	    Vector.prototype.dotProduct = function (anotherVector) {
	        return this.x * anotherVector.x + this.y * anotherVector.y;
	    };
	    Vector.prototype.edge = function (anotherVector) {
	        return this.subtract(anotherVector);
	    };
	    Vector.prototype.perpendicular = function () {
	        var v = new Vector();
	        v.x = this.y;
	        v.y = 0 - this.x;
	        return v;
	    };
	    Vector.prototype.normalize = function () {
	        var v = new Vector(0, 0);
	        var m = this.getMagnitude();
	        if (m != 0) {
	            v.x = this.x / m;
	            v.y = this.y / m;
	        }
	        return v;
	    };
	    Vector.prototype.perpendicularNormal = function () {
	        var p = this.perpendicular();
	        return p.normalize();
	    };
	    Vector.prototype.parallel = function (vector) {
	        if (Math.abs(this.x * vector.y - this.y * vector.x) < 0.00001) {
	            return true;
	        }
	        else {
	            return false;
	        }
	    };
	    Vector.symmetricVector = function (vector, normalVector) {
	        var nx2 = normalVector.x * normalVector.x;
	        var ny2 = normalVector.y * normalVector.y;
	        var nxy = normalVector.x * normalVector.y;
	        var x = (2 * vector.y * nxy + vector.x * (nx2 - ny2)) / (nx2 + ny2);
	        var y = (2 * vector.x * nxy - vector.y * (nx2 - ny2)) / (nx2 + ny2);
	        return new Vector(x, y);
	    };
	    return Vector;
	}());

	var Projection = (function () {
	    function Projection(min, max) {
	        this.min = min;
	        this.max = max;
	    }
	    Projection.prototype.overlaps = function (projection) {
	        return this.max > projection.min && projection.max > this.min;
	    };
	    return Projection;
	}());

	var Ball = (function () {
	    function Ball(radius, view) {
	        this.collideStatus = 1;
	        this.recoverMark = false;
	        this.velocity = new Vector();
	        this.radius = radius;
	        this.view = view;
	    }
	    Object.defineProperty(Ball.prototype, "_viewx", {
	        get: function () {
	            return this.view.x;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Ball.prototype, "_viewy", {
	        get: function () {
	            return this.view.y;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Ball.prototype.project = function (axis) {
	        var scalars = [];
	        var dotProduct = new Vector(this.view.x, this.view.y).dotProduct(axis);
	        scalars.push(dotProduct + this.radius);
	        scalars.push(dotProduct - this.radius);
	        return new Projection(dotProduct - this.radius, dotProduct + this.radius);
	    };
	    return Ball;
	}());

	var createBallItem = function () {
	    var picTex = getTextureByName("ball");
	    var pic = new engine.Image(picTex);
	    pic.mouseEnabled = false;
	    pic.anchorX = pic.width / 2;
	    pic.anchorY = pic.height / 2;
	    var ball = new Ball(BALL_D / 2, pic);
	    return ball;
	};

	var TweenObj = (function () {
	    function TweenObj() {
	        this._instanceId = 0;
	        this._instanceType = "TweenObj";
	        this.currentFrame = 0;
	        this.totalFrames = 0;
	        this._isLoop = 0;
	        this._delay = 0;
	        this._isFront = true;
	        this._cParams = null;
	        this._loop = false;
	        this._instanceId = TweenObj._object_id++;
	    }
	    TweenObj.prototype.init = function (target, times, data, isTo) {
	        if (isTo === void 0) { isTo = true; }
	        if (times <= 0 || typeof (times) != "number") {
	            throw new Error("Tween.to()或者Tween.from()方法的第二个参数一定要是大于0的数字");
	        }
	        var s = this;
	        s.currentFrame = 1;
	        var tTime = times * 60 >> 0;
	        s.totalFrames = tTime > 0 ? tTime : 1;
	        s.target = target;
	        s._isTo = isTo;
	        s._isLoop = 0;
	        s._startData = {};
	        s._disData = {};
	        s._delay = 0;
	        s._isFront = true;
	        s._ease = null;
	        s._update = null;
	        s._cParams = null;
	        s._loop = false;
	        s._completeFun = null;
	        for (var item in data) {
	            switch (item) {
	                case "useFrame":
	                    if (data[item] == true) {
	                        s.totalFrames = times;
	                    }
	                    break;
	                case "yoyo":
	                    if (data[item] === false) {
	                        s._isLoop = 0;
	                    }
	                    else if (data[item] === true) {
	                        s._isLoop = Number.MAX_VALUE;
	                    }
	                    else {
	                        s._isLoop = data[item];
	                    }
	                    break;
	                case "delay":
	                    if (data.useFrame) {
	                        s._delay = data[item];
	                    }
	                    else {
	                        s._delay = data[item] * 60 >> 0;
	                    }
	                    break;
	                case "ease":
	                    s._ease = data[item];
	                    break;
	                case "onUpdate":
	                    s._update = data[item];
	                    break;
	                case "onComplete":
	                    s._completeFun = data[item];
	                    break;
	                case "completeParams":
	                    s._cParams = data[item];
	                    break;
	                case "loop":
	                    s._loop = data[item];
	                    break;
	                default:
	                    if (typeof (data[item]) == "number") {
	                        if (isTo) {
	                            s._startData[item] = target[item];
	                            s._disData[item] = data[item] - target[item];
	                        }
	                        else {
	                            s._startData[item] = data[item];
	                            s._disData[item] = target[item] - data[item];
	                            target[item] = data[item];
	                        }
	                    }
	            }
	        }
	    };
	    TweenObj.prototype.update = function () {
	        var s = this;
	        if (s._isFront && s._delay > 0) {
	            s._delay--;
	            return;
	        }
	        var per = s.currentFrame / s.totalFrames;
	        if (per < 0 || per > 1)
	            return;
	        if (s._ease) {
	            per = s._ease(per);
	        }
	        var isHave = false;
	        for (var item in s._disData) {
	            isHave = true;
	            s.target[item] = s._startData[item] + s._disData[item] * per;
	        }
	        if (!isHave) {
	            Tween.kill(s.instanceId);
	            return;
	        }
	        if (s._update) {
	            s._update(per);
	        }
	        var cf = s._completeFun;
	        var pm = s._cParams;
	        if (s._isFront) {
	            s.currentFrame++;
	            if (s.currentFrame > s.totalFrames) {
	                if (s._loop) {
	                    s.currentFrame = 1;
	                }
	                else {
	                    if (s._isLoop > 0) {
	                        s._isFront = false;
	                        s.currentFrame = s.totalFrames;
	                        s._isLoop--;
	                    }
	                    else {
	                        Tween.kill(s.instanceId);
	                    }
	                }
	                if (cf) {
	                    cf(pm);
	                }
	            }
	        }
	        else {
	            s.currentFrame--;
	            if (s.currentFrame < 0) {
	                if (s._isLoop > 0) {
	                    s._isFront = true;
	                    s.currentFrame = 1;
	                }
	                else {
	                    Tween.kill(s.instanceId);
	                }
	                if (cf) {
	                    cf(pm);
	                }
	            }
	        }
	    };
	    Object.defineProperty(TweenObj.prototype, "instanceId", {
	        get: function () {
	            return this._instanceId;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TweenObj.prototype, "instanceType", {
	        get: function () {
	            return this._instanceType;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    TweenObj.prototype.destroy = function () {
	        var s = this;
	        s._update = null;
	        s._completeFun = null;
	        s._ease = null;
	    };
	    TweenObj._object_id = 0;
	    return TweenObj;
	}());
	var Tween = (function () {
	    function Tween() {
	    }
	    Tween.to = function (target, totalFrame, data) {
	        return Tween.createTween(target, totalFrame, data, true);
	    };
	    Tween.from = function (target, totalFrame, data) {
	        return Tween.createTween(target, totalFrame, data, false);
	    };
	    Tween.createTween = function (target, totalFrame, data, isTo) {
	        var tweenObj;
	        var len = Tween._tweenList.length;
	        for (var i = 0; i < len; i++) {
	            tweenObj = Tween._tweenList[i];
	            if (target == tweenObj.target) {
	                for (var item in tweenObj._startData) {
	                    if (data[item] != undefined) {
	                        delete tweenObj._startData[item];
	                        delete tweenObj._disData[item];
	                    }
	                }
	            }
	        }
	        len = Tween._tweenPool.length;
	        if (len > 0) {
	            tweenObj = Tween._tweenPool.shift();
	            tweenObj._instanceId = TweenObj["_object_id"]++;
	        }
	        else {
	            tweenObj = new TweenObj();
	        }
	        Tween._tweenList.push(tweenObj);
	        tweenObj.init(target, totalFrame, data, isTo);
	        return tweenObj.instanceId;
	    };
	    Tween.killAll = function () {
	        var len = Tween._tweenList.length;
	        var tweenObj;
	        for (var i = 0; i < len; i++) {
	            tweenObj = Tween._tweenList[i];
	            tweenObj.target = null;
	            tweenObj._completeFun = null;
	            tweenObj._cParams = null;
	            tweenObj._update = null;
	            tweenObj._ease = null;
	            tweenObj._loop = false;
	            Tween._tweenPool.push(tweenObj);
	        }
	        Tween._tweenList.length = 0;
	    };
	    Tween.kill = function (tweenId) {
	        var len = Tween._tweenList.length;
	        var tweenObj;
	        for (var i = 0; i < len; i++) {
	            tweenObj = Tween._tweenList[i];
	            if (tweenObj.instanceId == tweenId) {
	                tweenObj.target = null;
	                tweenObj._completeFun = null;
	                tweenObj._cParams = null;
	                tweenObj._update = null;
	                tweenObj._ease = null;
	                tweenObj._loop = null;
	                Tween._tweenPool.push(tweenObj);
	                Tween._tweenList.splice(i, 1);
	                break;
	            }
	        }
	    };
	    Tween.quadraticIn = function (k) {
	        return k * k;
	    };
	    Tween.quadraticOut = function (k) {
	        return k * (2 - k);
	    };
	    Tween.quadraticInOut = function (k) {
	        if ((k *= 2) < 1) {
	            return 0.5 * k * k;
	        }
	        return -0.5 * (--k * (k - 2) - 1);
	    };
	    Tween.cubicIn = function (k) {
	        return k * k * k;
	    };
	    Tween.cubicOut = function (k) {
	        return --k * k * k + 1;
	    };
	    Tween.cubicInOut = function (k) {
	        if ((k *= 2) < 1) {
	            return 0.5 * k * k * k;
	        }
	        return 0.5 * ((k -= 2) * k * k + 2);
	    };
	    Tween.quarticIn = function (k) {
	        return k * k * k * k;
	    };
	    Tween.quarticOut = function (k) {
	        return 1 - (--k * k * k * k);
	    };
	    Tween.quarticInOut = function (k) {
	        if ((k *= 2) < 1) {
	            return 0.5 * k * k * k * k;
	        }
	        return -0.5 * ((k -= 2) * k * k * k - 2);
	    };
	    Tween.quinticIn = function (k) {
	        return k * k * k * k * k;
	    };
	    Tween.quinticOut = function (k) {
	        return --k * k * k * k * k + 1;
	    };
	    Tween.quinticInOut = function (k) {
	        if ((k *= 2) < 1) {
	            return 0.5 * k * k * k * k * k;
	        }
	        return 0.5 * ((k -= 2) * k * k * k * k + 2);
	    };
	    Tween.sinusoidalIn = function (k) {
	        return 1 - Math.cos(k * Math.PI / 2);
	    };
	    Tween.sinusoidalOut = function (k) {
	        return Math.sin(k * Math.PI / 2);
	    };
	    Tween.sinusoidalInOut = function (k) {
	        return 0.5 * (1 - Math.cos(Math.PI * k));
	    };
	    Tween.exponentialIn = function (k) {
	        return k === 0 ? 0 : Math.pow(1024, k - 1);
	    };
	    Tween.exponentialOut = function (k) {
	        return k === 1 ? 1 : 1 - Math.pow(2, -10 * k);
	    };
	    Tween.exponentialInOut = function (k) {
	        if (k === 0) {
	            return 0;
	        }
	        if (k === 1) {
	            return 1;
	        }
	        if ((k *= 2) < 1) {
	            return 0.5 * Math.pow(1024, k - 1);
	        }
	        return 0.5 * (-Math.pow(2, -10 * (k - 1)) + 2);
	    };
	    Tween.circularIn = function (k) {
	        return 1 - Math.sqrt(1 - k * k);
	    };
	    Tween.circularOut = function (k) {
	        return Math.sqrt(1 - (--k * k));
	    };
	    Tween.circularInOut = function (k) {
	        if ((k *= 2) < 1) {
	            return -0.5 * (Math.sqrt(1 - k * k) - 1);
	        }
	        return 0.5 * (Math.sqrt(1 - (k -= 2) * k) + 1);
	    };
	    Tween.elasticIn = function (k) {
	        if (k === 0) {
	            return 0;
	        }
	        if (k === 1) {
	            return 1;
	        }
	        return -Math.pow(2, 10 * (k - 1)) * Math.sin((k - 1.1) * 5 * Math.PI);
	    };
	    Tween.elasticOut = function (k) {
	        if (k === 0) {
	            return 0;
	        }
	        if (k === 1) {
	            return 1;
	        }
	        return Math.pow(2, -10 * k) * Math.sin((k - 0.1) * 5 * Math.PI) + 1;
	    };
	    Tween.elasticInOut = function (k) {
	        if (k === 0) {
	            return 0;
	        }
	        if (k === 1) {
	            return 1;
	        }
	        k *= 2;
	        if (k < 1) {
	            return -0.5 * Math.pow(2, 10 * (k - 1)) * Math.sin((k - 1.1) * 5 * Math.PI);
	        }
	        return 0.5 * Math.pow(2, -10 * (k - 1)) * Math.sin((k - 1.1) * 5 * Math.PI) + 1;
	    };
	    Tween.backIn = function (k) {
	        var s = 1.70158;
	        return k * k * ((s + 1) * k - s);
	    };
	    Tween.backOut = function (k) {
	        var s = 1.70158;
	        return --k * k * ((s + 1) * k + s) + 1;
	    };
	    Tween.backInOut = function (k) {
	        var s = 1.70158 * 1.525;
	        if ((k *= 2) < 1) {
	            return 0.5 * (k * k * ((s + 1) * k - s));
	        }
	        return 0.5 * ((k -= 2) * k * ((s + 1) * k + s) + 2);
	    };
	    Tween.bounceIn = function (k) {
	        return 1 - Tween.bounceOut(1 - k);
	    };
	    Tween.bounceOut = function (k) {
	        if (k < (1 / 2.75)) {
	            return 7.5625 * k * k;
	        }
	        else if (k < (2 / 2.75)) {
	            return 7.5625 * (k -= (1.5 / 2.75)) * k + 0.75;
	        }
	        else if (k < (2.5 / 2.75)) {
	            return 7.5625 * (k -= (2.25 / 2.75)) * k + 0.9375;
	        }
	        else {
	            return 7.5625 * (k -= (2.625 / 2.75)) * k + 0.984375;
	        }
	    };
	    Tween.bounceInOut = function (k) {
	        if (k < 0.5) {
	            return Tween.bounceIn(k * 2) * 0.5;
	        }
	        return Tween.bounceOut(k * 2 - 1) * 0.5 + 0.5;
	    };
	    Tween.flush = function () {
	        var len = Tween._tweenList.length;
	        for (var i = len - 1; i >= 0; i--) {
	            if (Tween._tweenList[i]) {
	                Tween._tweenList[i].update();
	            }
	            else {
	                Tween._tweenList.splice(i, 1);
	            }
	        }
	    };
	    Tween._tweenPool = [];
	    Tween._tweenList = [];
	    return Tween;
	}());

	var Body = (function () {
	    function Body() {
	        this.ladderNums = 1;
	    }
	    Body.prototype.collideBall = function (ball) {
	    };
	    Object.defineProperty(Body.prototype, "num", {
	        get: function () {
	            return;
	        },
	        set: function (value) {
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Body.prototype, "y", {
	        set: function (value) { },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Body.prototype, "x", {
	        set: function (value) { },
	        enumerable: true,
	        configurable: true
	    });
	    return Body;
	}());

	var Circle = (function (_super) {
	    tslib.__extends(Circle, _super);
	    function Circle(radius, view) {
	        var _this = _super.call(this) || this;
	        _this.type = "circle";
	        _this._x = 0;
	        _this._y = 0;
	        _this.radius = radius;
	        _this.view = view;
	        return _this;
	    }
	    Object.defineProperty(Circle.prototype, "x", {
	        get: function () {
	            return this._x;
	        },
	        set: function (value) {
	            if (this._x != value) {
	                this._x = value;
	                this.view.x = value;
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Circle.prototype, "y", {
	        get: function () {
	            return this._y;
	        },
	        set: function (value) {
	            if (this._y != value) {
	                this._y = value;
	                this.view.y = value;
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Circle.prototype, "num", {
	        get: function () {
	            return this._num;
	        },
	        set: function (value) {
	            if (this._num != value) {
	                this._num = value;
	                this.view.txt && (this.view.txt.text = value || 2 + "");
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Circle.prototype, "_viewx", {
	        get: function () {
	            return this.view.x;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Circle.prototype, "_viewy", {
	        get: function () {
	            return this.view.y;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Circle.prototype.shake = function () {
	        var startx = -this.view.bg.anchorX;
	        var starty = -this.view.bg.anchorY;
	        this.view.bg.x = startx;
	        this.view.bg.y = starty;
	        Tween.to(this.view.bg, 1, {
	            x: startx + 3,
	            y: starty + 3,
	            yoyo: 2,
	            useFrame: true,
	            onComplete: function () {
	                console.log("circle震动3-------", this.view.bg.x, this.view.bg.y);
	            }
	        });
	    };
	    Circle.prototype.collideBall = function (ball) {
	        var ballax = ball._viewx;
	        var ballay = ball._viewy;
	        var thisax = this._viewx;
	        var thisay = this._viewy;
	        var deltaX = ballax - thisax;
	        var deltaY = ballay - thisay;
	        if (deltaX * deltaX + deltaY * deltaY < (this.radius + ball.radius) * (this.radius + ball.radius)) {
	            var velocity = ball.velocity.clone();
	            var deta = Math.floor(velocity.length() / ball.radius) + 5;
	            var speedX = velocity.x / (deta + 1);
	            var speedY = velocity.y / (deta + 1);
	            for (var i = 0; i <= deta; i++) {
	                var normal = this.nearestCollideNormal({ x: ballax - speedX * (i + 1), y: ballay - speedY * (i + 1) }, ball, deta + 1, i + 1);
	                if (normal) {
	                    return normal;
	                }
	            }
	        }
	        else {
	            return false;
	        }
	    };
	    Circle.prototype.nearestCollideNormal = function (position, ball, deta, i) {
	        var thisax = this._viewx;
	        var thisay = this._viewy;
	        var deltaX = position.x - thisax;
	        var deltaY = position.y - thisay;
	        if (deltaX * deltaX + deltaY * deltaY < (this.radius + ball.radius) * (this.radius + ball.radius)) {
	            return false;
	        }
	        else {
	            ball.view.x -= ball.velocity.x / deta * i;
	            ball.view.y -= ball.velocity.y / deta * i;
	            return new Vector(deltaX, deltaY).cross();
	        }
	    };
	    return Circle;
	}(Body));

	var createCircle = (function (that, x, y, num) {
	    var block = that.pool.takeOut("circle");
	    var anchorx = 0;
	    var anchory = 0;
	    if (!block) {
	        var sprite = new engine.Sprite();
	        sprite.mouseEnabled = sprite.mouseChildren = false;
	        var shape = new engine.Image(getTextureByName('circle1'));
	        shape['__resName__'] = 'circle1';
	        var radius = shape.width / 2;
	        var length = radius * 2;
	        shape.anchorX = shape.width / 2;
	        shape.anchorY = shape.height / 2;
	        anchorx = radius;
	        anchory = radius;
	        sprite["bg"] = shape;
	        sprite.addChild(shape);
	        shape.x = -anchorx;
	        shape.y = -anchory;
	        var txt = new engine.TextField();
	        txt.width = length;
	        txt.height = length;
	        txt.anchorX = length / 2;
	        txt.anchorY = length / 2;
	        txt.size = 30;
	        txt.fillColor = 0xffffff;
	        txt.textAlign = engine.TEXT_ALIGN.CENTER;
	        txt.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	        sprite["txt"] = txt;
	        sprite.addChild(txt);
	        txt.x = -anchorx;
	        txt.y = -anchory;
	        block = new Circle(radius, sprite);
	    }
	    engine.Tween.removeTweens(block.view);
	    that.addChild(block.view);
	    block.x = x;
	    block.y = y;
	    block.num = num;
	    that.blocks.push(block);
	    block.ladderNums = 1;
	});

	var degToRad = Math.PI / 180;
	var radToDeg = 180 / Math.PI;
	var sqrt3 = Math.sqrt(3);
	function translateToLocalCor(p, parent) {
	    var th = parent.rotation * degToRad;
	    var xp = p.x - parent.x;
	    var yp = p.y - parent.y;
	    var x = xp * Math.cos(th) + yp * Math.sin(th);
	    var y = yp * Math.cos(th) - xp * Math.sin(th);
	    return { x: x / parent.scaleX, y: y / parent.scaleY };
	}

	var RegPolygon = (function (_super) {
	    tslib.__extends(RegPolygon, _super);
	    function RegPolygon(length, view) {
	        var _this = _super.call(this) || this;
	        _this.type = "regPolygon";
	        _this._rotation = 0;
	        _this._x = 0;
	        _this._y = 0;
	        _this.linesOri = [];
	        _this.sideNormals = [];
	        _this.pointNormals = [];
	        _this.points = [];
	        _this.axes = [];
	        _this.projects = [];
	        _this.dirty = true;
	        _this.length = length;
	        _this.view = view;
	        _this.calculateNormals();
	        _this.calculatePoints();
	        _this.calculateLines();
	        return _this;
	    }
	    Object.defineProperty(RegPolygon.prototype, "rotation", {
	        get: function () {
	            return this._rotation;
	        },
	        set: function (value) {
	            if (this._rotation != value) {
	                this._rotation = value;
	                this.view.rotation = value;
	                this.view.txt.rotation = -value;
	                this.calculateNormals();
	                this.calculatePoints();
	                this.dirty = true;
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(RegPolygon.prototype, "x", {
	        get: function () {
	            return this._x;
	        },
	        set: function (value) {
	            if (this._x != value) {
	                this._x = value;
	                this.view.x = value;
	                this.dirty = true;
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(RegPolygon.prototype, "y", {
	        get: function () {
	            return this._y;
	        },
	        set: function (value) {
	            if (this._y != value) {
	                this._y = value;
	                this.view.y = value;
	                this.dirty = true;
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(RegPolygon.prototype, "num", {
	        get: function () {
	            return this._num;
	        },
	        set: function (value) {
	            if (this._num != value) {
	                this._num = value;
	                this.view.txt.text = value || 3 + "";
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(RegPolygon.prototype, "_viewx", {
	        get: function () {
	            return this.view.x;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(RegPolygon.prototype, "_viewy", {
	        get: function () {
	            return this.view.y;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    RegPolygon.prototype.calculateNormals = function () {
	    };
	    RegPolygon.prototype.calculatePoints = function () {
	    };
	    RegPolygon.prototype.calculateLines = function () {
	    };
	    RegPolygon.prototype.getAxes = function () {
	        var v1 = new Vector();
	        var v2 = new Vector();
	        var axes = [];
	        var thisvx = this._viewx;
	        var thisvy = this._viewy;
	        for (var i = 0; i < this.points.length - 1; i++) {
	            v1.x = this.points[i].x + thisvx;
	            v1.y = this.points[i].y + thisvy;
	            v2.x = this.points[i + 1].x + thisvx;
	            v2.y = this.points[i + 1].y + thisvy;
	            axes.push(v1.edge(v2).perpendicularNormal());
	        }
	        v1.x = this.points[this.points.length - 1].x + thisvx;
	        v1.y = this.points[this.points.length - 1].y + thisvy;
	        v2.x = this.points[0].x + thisvx;
	        v2.y = this.points[0].y + thisvy;
	        axes.push(v1.edge(v2).perpendicularNormal());
	        return axes;
	    };
	    RegPolygon.prototype.project = function (axis) {
	        var scalars = [];
	        var v = new Vector();
	        var thisvx = this._viewx;
	        var thisvy = this._viewy;
	        this.points.forEach(function (point) {
	            v.x = point.x + thisvx;
	            v.y = point.y + thisvy;
	            scalars.push(v.dotProduct(axis));
	        });
	        return new Projection(Math.min.apply(Math, scalars), Math.max.apply(Math, scalars));
	    };
	    RegPolygon.prototype.polygonCollidesWithCircle = function (ball) {
	        var v1;
	        var v2;
	        var ballax = ball._viewx;
	        var ballay = ball._viewy;
	        if (this.dirty) {
	            this.dirty = false;
	            this.axes = this.getAxes();
	            for (var i = 0; i < this.axes.length; i++) {
	                this.projects[i] = this.project(this.axes[i]);
	            }
	        }
	        var axes = this.axes.slice();
	        var closestPoint = this.getPolygonPointClosestToCircle(ball);
	        v1 = new Vector(ballax, ballay);
	        v2 = new Vector(closestPoint.x, closestPoint.y);
	        axes.push(v1.subtract(v2).normalize());
	        return !this.separationOnAxes(axes, ball);
	    };
	    RegPolygon.prototype.getPolygonPointClosestToCircle = function (ball) {
	        var min;
	        var length;
	        var testPoint;
	        var closestPoint;
	        var ballax = ball._viewx;
	        var ballay = ball._viewy;
	        var thisax = this._viewx;
	        var thisay = this._viewy;
	        for (var i = 0; i < this.points.length; i++) {
	            testPoint = new Vector(this.points[i].x + thisax, this.points[i].y + thisay);
	            length = Math.pow(testPoint.x - ballax, 2) + Math.pow(testPoint.y - ballay, 2);
	            if (!min || length < min) {
	                min = length;
	                closestPoint = testPoint;
	            }
	        }
	        return closestPoint;
	    };
	    RegPolygon.prototype.separationOnAxes = function (axes, ball) {
	        var axis;
	        var projection1;
	        var projection2;
	        for (var i = 0; i < axes.length; ++i) {
	            axis = axes[i];
	            projection1 = ball.project(axis);
	            if (i == axes.length - 1) {
	                projection2 = this.project(axis);
	            }
	            else {
	                projection2 = this.projects[i];
	            }
	            if (!projection1.overlaps(projection2)) {
	                return true;
	            }
	        }
	        return false;
	    };
	    RegPolygon.prototype.collideBall = function (ball) {
	        var ballax = ball._viewx;
	        var ballay = ball._viewy;
	        var thisax = this._viewx;
	        var thisay = this._viewy;
	        if (this.polygonCollidesWithCircle(ball)) {
	            var returnP = translateToLocalCor({ x: ballax, y: ballay }, this.view);
	            var velocity = ball.velocity.clone().rotate(-this._rotation * degToRad);
	            var deta = Math.floor(velocity.length() / ball.radius) + 1;
	            var speedX = velocity.x / (deta + 1);
	            var speedY = velocity.y / (deta + 1);
	            for (var i = 0; i <= deta; i++) {
	                this.ballPosition(ball, deta + 1, i + 1);
	                if (!this.polygonCollidesWithCircle(ball)) {
	                    var noraml = this.nearestCollideNormal({ x: returnP.x - speedX * (i + 1), y: returnP.y - speedY * (i + 1) });
	                    return noraml;
	                }
	            }
	            ball.view.x += ball.velocity.x;
	            ball.view.y += ball.velocity.y;
	            return false;
	        }
	        else {
	            return false;
	        }
	    };
	    RegPolygon.prototype.nearestCollideNormal = function (returnP) {
	        return;
	    };
	    RegPolygon.prototype.ballPosition = function (ball, deta, i) {
	        ball.view.x -= ball.velocity.x / deta;
	        ball.view.y -= ball.velocity.y / deta;
	    };
	    RegPolygon.prototype.shake = function () {
	        var startx = -this.view.bg.anchorX;
	        var starty = -this.view.bg.anchorY;
	        this.view.bg.x = startx;
	        this.view.bg.y = starty;
	        Tween.to(this.view.bg, 1, {
	            x: startx + 3,
	            y: starty + 3,
	            yoyo: 2,
	            useFrame: true,
	            onComplete: function () {
	            }
	        });
	    };
	    return RegPolygon;
	}(Body));

	var RegTriangle = (function (_super) {
	    tslib.__extends(RegTriangle, _super);
	    function RegTriangle(length, view) {
	        var _this = _super.call(this, length, view) || this;
	        _this.type = "regTriangle";
	        _this.pointLength = _this.length * sqrt3 / 3;
	        _this.sideLength = _this.length * sqrt3 / 6;
	        return _this;
	    }
	    RegTriangle.prototype.calculateNormals = function () {
	        if (this._rotation == 0) {
	            this.sideNormals[0] = new Vector(1, -sqrt3);
	            this.sideNormals[1] = new Vector(1, sqrt3);
	            this.sideNormals[2] = new Vector(-1, 0);
	            this.pointNormals[0] = new Vector(1, 0);
	            this.pointNormals[1] = new Vector(-1, sqrt3);
	            this.pointNormals[2] = new Vector(-1, -sqrt3);
	        }
	        else {
	            var rad = this._rotation * degToRad;
	            this.sideNormals[0] = new Vector(1, -sqrt3).rotate(rad);
	            this.sideNormals[1] = new Vector(1, sqrt3).rotate(rad);
	            this.sideNormals[2] = new Vector(-1, 0).rotate(rad);
	            this.pointNormals[0] = new Vector(1, 0).rotate(rad);
	            this.pointNormals[1] = new Vector(-1, sqrt3).rotate(rad);
	            this.pointNormals[2] = new Vector(-1, -sqrt3).rotate(rad);
	        }
	    };
	    RegTriangle.prototype.calculatePoints = function () {
	        if (this._rotation == 0) {
	            this.points[0] = new Vector(0, -this.length * sqrt3 / 3);
	            this.points[1] = new Vector(this.length / 2, this.length * sqrt3 / 6);
	            this.points[2] = new Vector(-this.length / 2, this.length * sqrt3 / 6);
	        }
	        else {
	            var rad = this._rotation * degToRad;
	            this.points[0] = new Vector(0, -this.length * sqrt3 / 3).rotate(rad);
	            this.points[1] = new Vector(this.length / 2, this.length * sqrt3 / 6).rotate(rad);
	            this.points[2] = new Vector(-this.length / 2, this.length * sqrt3 / 6).rotate(rad);
	        }
	    };
	    RegTriangle.prototype.calculateLines = function () {
	        this.linesOri = [
	            { a: -sqrt3, b: -this.length * sqrt3 / 3 },
	            { a: sqrt3, b: -this.length * sqrt3 / 3 },
	            { a: 0, b: this.length * sqrt3 / 6 },
	        ];
	    };
	    RegTriangle.prototype.nearestCollideNormal = function (returnP) {
	        var zero = this.linesOri[0].a * returnP.x + this.linesOri[0].b - returnP.y > 0;
	        var one = this.linesOri[1].a * returnP.x + this.linesOri[1].b - returnP.y > 0;
	        var two = this.linesOri[2].a * returnP.x + this.linesOri[2].b - returnP.y > 0;
	        if (zero && !one && two) {
	            return this.sideNormals[0];
	        }
	        else if (!zero && one && two) {
	            return this.sideNormals[1];
	        }
	        else if (!zero && !one && !two) {
	            return this.sideNormals[2];
	        }
	        else if (zero && one && two) {
	            return this.pointNormals[0];
	        }
	        else if (!zero && one && !two) {
	            return this.pointNormals[1];
	        }
	        else if (zero && !one && !two) {
	            return this.pointNormals[2];
	        }
	    };
	    return RegTriangle;
	}(RegPolygon));

	var createRegTriangle = (function (that, x, y, num) {
	    var block = that.pool.takeOut("regTriangle");
	    var picType = Math.ceil(Math.random() * 2);
	    var pic = new engine.Sprite(getTextureByName("tri" + picType));
	    pic.anchorX = pic.width / 2;
	    pic.anchorY = pic.height / 2;
	    var anchorx = 0;
	    var anchory = 0;
	    anchorx = pic.width / 2;
	    anchory = pic.height / 2;
	    if (!block) {
	        var sprite = new engine.Sprite();
	        sprite.mouseEnabled = sprite.mouseChildren = false;
	        var length = pic.width;
	        var height = pic.height;
	        sprite["bg"] = pic;
	        sprite.addChild(pic);
	        pic.x = -anchorx;
	        pic.y = -anchory;
	        var txt = new engine.TextField();
	        txt.width = length;
	        txt.height = height;
	        txt.anchorX = length / 2;
	        txt.anchorY = height / 2;
	        txt.size = 26;
	        txt.fillColor = 0xffffff;
	        txt.textAlign = engine.TEXT_ALIGN.CENTER;
	        txt.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	        sprite["txt"] = txt;
	        sprite.addChild(txt);
	        txt.x = -anchorx;
	        txt.y = -anchory + (anchorx - anchory) * 2;
	        block = new RegTriangle(length, sprite);
	    }
	    else {
	        if (block.view["bg"]) {
	            block.view.removeChild(block.view["bg"]);
	            block.view["bg"] = pic;
	            block.view.addChild(pic);
	            block.view.addChild(block.view['txt']);
	            pic.x = -anchorx;
	            pic.y = -anchory;
	            block.view['txt'].x = -anchorx;
	            block.view['txt'].y = -anchory + (anchorx - anchory) * 2;
	        }
	    }
	    engine.Tween.removeTweens(block.view);
	    block.view["bg"]['__resName__'] = "tri" + picType;
	    that.addChild(block.view);
	    block.x = x;
	    block.y = y;
	    block.rotation = Math.random() * 360;
	    block.num = num;
	    that.blocks.push(block);
	    block.ladderNums = 1;
	});

	var createSpecialRegTriangle = (function (that, x, y, length, rotation, key) {
	    if (key === void 0) { key = 'specialRegTriangle'; }
	    var block;
	    var sprite = new engine.Sprite();
	    sprite.visible = false;
	    sprite.alpha = 0.7;
	    sprite.mouseEnabled = sprite.mouseChildren = false;
	    var shape = new engine.Shape();
	    shape.beginFill(0xcccccc);
	    shape.moveTo(0, -length * sqrt3 / 3);
	    shape.lineTo(length / 2, length * sqrt3 / 6);
	    shape.lineTo(-length / 2, length * sqrt3 / 6);
	    shape.endFill();
	    sprite["bg"] = shape;
	    sprite.addChild(shape);
	    var txt = new engine.TextField();
	    txt.width = length;
	    txt.height = length;
	    txt.anchorX = length / 2;
	    txt.anchorY = length / 2;
	    txt.size = 25;
	    txt.fillColor = 0xffffff;
	    txt.textAlign = engine.TEXT_ALIGN.CENTER;
	    txt.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	    sprite["txt"] = txt;
	    sprite.addChild(txt);
	    block = new RegTriangle(length, sprite);
	    block.type = key;
	    that.addChild(block.view);
	    block.x = x - BALL_D / 2;
	    block.y = y - BALL_D / 2;
	    block.rotation = rotation;
	    that.blocks.push(block);
	});

	var createSpeialCircle = (function (that, x, y, num) {
	    var block = that.pool.takeOut("specialCircle");
	    var radius = getTextureByName('+1').orig.width / 2;
	    if (!block) {
	        var sprite = new engine.Sprite();
	        sprite.mouseEnabled = sprite.mouseChildren = false;
	        var shape = new engine.Sprite(getTextureByName('+1'));
	        shape.anchorX = shape.width / 2;
	        shape.anchorY = shape.height / 2;
	        sprite["bg"] = shape;
	        sprite.addChild(shape);
	        shape.x = -shape.width / 2;
	        shape.y = -shape.height / 2;
	        block = new Circle(radius, sprite);
	        block.type = 'specialCircle';
	    }
	    else {
	        if (block.radius != radius) {
	            block.view.bg.clear();
	            block.view.bg.beginFill(0xcccccc);
	            block.view.bg.drawCircle(0, 0, radius);
	            block.view.bg.endFill();
	        }
	    }
	    engine.Tween.removeTweens(block.view);
	    that.addChild(block.view);
	    block.x = x;
	    block.y = y;
	    block.num = num;
	    that.blocks.push(block);
	    block.ladderNums = 1;
	});

	var Square = (function (_super) {
	    tslib.__extends(Square, _super);
	    function Square(length, view) {
	        var _this = _super.call(this) || this;
	        _this.type = "square";
	        _this._x = 0;
	        _this._y = 0;
	        _this._rotation = 0;
	        _this.sideNormals = [
	            new Vector(1, 0),
	            new Vector(0, 1),
	            new Vector(-1, 0),
	            new Vector(0, -1)
	        ];
	        _this.pointNormals = [
	            new Vector(1, -1),
	            new Vector(1, 1),
	            new Vector(-1, 1),
	            new Vector(-1, -1)
	        ];
	        _this.length = length;
	        _this.view = view;
	        return _this;
	    }
	    Object.defineProperty(Square.prototype, "rotation", {
	        get: function () {
	            return this._rotation;
	        },
	        set: function (value) {
	            if (this._rotation != value) {
	                this._rotation = value;
	                this.view.rotation = value;
	                this.view.txt.rotation = -value;
	                var rad = value * degToRad;
	                this.sideNormals[0] = new Vector(1, 0).rotate(rad);
	                this.sideNormals[1] = new Vector(0, 1).rotate(rad);
	                this.sideNormals[2] = new Vector(-1, 0).rotate(rad);
	                this.sideNormals[3] = new Vector(0, -1).rotate(rad);
	                this.pointNormals[0] = new Vector(1, -1).rotate(rad);
	                this.pointNormals[1] = new Vector(1, 1).rotate(rad);
	                this.pointNormals[2] = new Vector(-1, 1).rotate(rad);
	                this.pointNormals[3] = new Vector(-1, -1).rotate(rad);
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Square.prototype, "x", {
	        get: function () {
	            return this._x;
	        },
	        set: function (value) {
	            if (this._x != value) {
	                this._x = value;
	                this.view.x = value;
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Square.prototype, "y", {
	        get: function () {
	            return this._y;
	        },
	        set: function (value) {
	            if (this._y != value) {
	                this._y = value;
	                this.view.y = value;
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Square.prototype, "num", {
	        get: function () {
	            return this._num;
	        },
	        set: function (value) {
	            if (this._num != value) {
	                this._num = value;
	                this.view.txt.text = value || 4 + "";
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Square.prototype, "_viewx", {
	        get: function () {
	            return this.view.x;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Square.prototype, "_viewy", {
	        get: function () {
	            return this.view.y;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Square.prototype.collideBall = function (ball) {
	        var returnP = translateToLocalCor({ x: ball._viewx, y: ball._viewy }, this.view);
	        var ox = -this.length / 2;
	        var oy = ox;
	        var nearestX = Math.max(ox, Math.min(returnP.x, ox + this.length));
	        var nearestY = Math.max(oy, Math.min(returnP.y, oy + this.length));
	        var deltaX = returnP.x - nearestX;
	        var deltaY = returnP.y - nearestY;
	        if (deltaX * deltaX + deltaY * deltaY < ball.radius * ball.radius) {
	            var velocity = ball.velocity.clone().rotate(-this._rotation * degToRad);
	            var deta = Math.floor(velocity.length() / ball.radius) + 5;
	            var speedX = velocity.x / (deta + 1);
	            var speedY = velocity.y / (deta + 1);
	            for (var i = 0; i <= deta; i++) {
	                var normal = this.nearestCollideNormal({ x: returnP.x - speedX * (i + 1), y: returnP.y - speedY * (i + 1) }, ball, deta + 1, i + 1);
	                if (normal) {
	                    return normal;
	                }
	            }
	        }
	        else {
	            return false;
	        }
	    };
	    Square.prototype.nearestCollideNormal = function (position, ball, deta, i) {
	        var ox = -this.length / 2;
	        var oy = ox;
	        var nearestX = Math.max(ox, Math.min(position.x, ox + this.length));
	        var nearestY = Math.max(oy, Math.min(position.y, oy + this.length));
	        var deltaX = position.x - nearestX;
	        var deltaY = position.y - nearestY;
	        if (deltaX * deltaX + deltaY * deltaY < ball.radius * ball.radius) {
	            return false;
	        }
	        else {
	            ball.view.x -= ball.velocity.x / deta * i;
	            ball.view.y -= ball.velocity.y / deta * i;
	            if (nearestX == ox) {
	                if (nearestY == oy) {
	                    return this.pointNormals[0];
	                }
	                else if (nearestY == oy + this.length) {
	                    return this.pointNormals[3];
	                }
	                else {
	                    return this.sideNormals[3];
	                }
	            }
	            else if (nearestX == ox + this.length) {
	                if (nearestY == oy) {
	                    return this.pointNormals[1];
	                }
	                else if (nearestY == oy + this.length) {
	                    return this.pointNormals[2];
	                }
	                else {
	                    return this.sideNormals[1];
	                }
	            }
	            else {
	                if (nearestY < 0) {
	                    return this.sideNormals[0];
	                }
	                else {
	                    return this.sideNormals[2];
	                }
	            }
	        }
	    };
	    Square.prototype.shake = function () {
	        var startx = -this.view.bg.anchorX;
	        var starty = -this.view.bg.anchorY;
	        this.view.bg.x = startx;
	        this.view.bg.y = starty;
	        Tween.to(this.view.bg, 1, {
	            x: startx + 5,
	            y: starty + 5,
	            yoyo: 3,
	            useFrame: true,
	            onComplete: function () {
	            }
	        });
	    };
	    return Square;
	}(Body));

	var createSquare = (function (that, x, y, num) {
	    var picType = Math.ceil(Math.random() * 4);
	    var pic = new engine.Sprite(getTextureByName("sq" + picType));
	    pic.anchorX = pic.width / 2;
	    pic.anchorY = pic.height / 2;
	    var block = that.pool.takeOut("square");
	    var anchorx = pic.width / 2;
	    var anchory = pic.height / 2;
	    if (!block) {
	        var sprite = new engine.Sprite();
	        sprite.mouseEnabled = sprite.mouseChildren = false;
	        var length = pic.width;
	        sprite["bg"] = pic;
	        sprite.addChild(pic);
	        pic.x = -anchorx;
	        pic.y = -anchory;
	        var txt = new engine.TextField();
	        txt.width = length;
	        txt.height = pic.height;
	        txt.anchorX = length / 2;
	        txt.anchorY = pic.height / 2;
	        txt.size = 30;
	        txt.fillColor = 0xffffff;
	        txt.textAlign = engine.TEXT_ALIGN.CENTER;
	        txt.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	        sprite["txt"] = txt;
	        sprite.addChild(txt);
	        txt.x = -anchorx;
	        txt.y = -anchory;
	        block = new Square(length, sprite);
	    }
	    else {
	        if (block.view["bg"]) {
	            block.view.removeChild(block.view["bg"]);
	            block.view["bg"] = pic;
	            block.view.addChild(pic);
	            block.view.addChild(block.view['txt']);
	            pic.x = -anchorx;
	            pic.y = -anchory;
	            block.view['txt'].x = -anchorx;
	            block.view['txt'].y = -anchory;
	        }
	    }
	    engine.Tween.removeTweens(block.view);
	    block.view["bg"]['__resName__'] = "sq" + picType;
	    that.addChild(block.view);
	    block.x = x;
	    block.y = y;
	    block.num = num;
	    block.rotation = Math.random() * 360;
	    that.blocks.push(block);
	    block.ladderNums = 1;
	});

	var Pool = (function () {
	    function Pool() {
	        this.pool = {};
	    }
	    Pool.prototype.takeOut = function (name) {
	        if (this.pool[name] && this.pool[name].length) {
	            return this.pool[name].shift();
	        }
	        return false;
	    };
	    Pool.prototype.recover = function (name, obj) {
	        if (!this.pool[name]) {
	            this.pool[name] = [];
	        }
	        this.pool[name].push(obj);
	    };
	    return Pool;
	}());

	var Effect = (function () {
	    function Effect(block, parent) {
	        this.NUMS_MAX = 11;
	        var resName = block.view['bg']['__resName__'];
	        var _loop_1 = function (i) {
	            var data = this_1.createItem(resName);
	            parent.addChild(data.shape);
	            data.shape.x = block.x;
	            data.shape.y = block.y;
	            engine.Tween.get(data.shape).to({ x: data.targetX + block.x, y: block.y + data.targetY, scaleY: 0, scaleX: 0 }, 360).call(function () {
	                data.shape.parent && data.shape.parent.removeChild(data.shape);
	            });
	        };
	        var this_1 = this;
	        for (var i = 0; i < this.NUMS_MAX; i++) {
	            _loop_1();
	        }
	    }
	    Effect.prototype.createItem = function (resName) {
	        var moveDisMax = 100;
	        var squareSize = 100;
	        var shape = new engine.Shape();
	        var shapeType = this.getShapeType(resName);
	        if (shapeType == 'circle') {
	            shape.beginFill(this.getShapeColor(resName));
	            shape.drawCircle(0, 0, squareSize / 2);
	            shape.endFill();
	        }
	        else if (shapeType == 'tri') {
	            shape.beginFill(this.getShapeColor(resName));
	            shape.moveTo(0, -squareSize * sqrt3 / 3);
	            shape.lineTo(squareSize / 2, squareSize * sqrt3 / 6);
	            shape.lineTo(-squareSize / 2, squareSize * sqrt3 / 6);
	            shape.endFill();
	        }
	        else if (shapeType == 'sq') {
	            shape.beginFill(this.getShapeColor(resName));
	            shape.drawRect(-squareSize / 2, -squareSize / 2, squareSize, squareSize);
	            shape.endFill();
	        }
	        var scale = Math.random() * 0.7 + 0.3;
	        var rotation = Math.random() * 360;
	        var angle = Math.random() * Math.PI * 2;
	        var dis = moveDisMax / 2 + moveDisMax / 2 * Math.random();
	        var targetX = Math.sin(angle) * dis;
	        var targetY = Math.cos(angle) * dis;
	        shape.scaleX = shape.scaleY = scale;
	        shape.rotation = rotation;
	        return { shape: shape, targetX: targetX, targetY: targetY };
	    };
	    Effect.prototype.getShapeType = function (resName) {
	        if (resName == 'circle1')
	            return 'circle';
	        if (resName.indexOf('tri') > -1)
	            return 'tri';
	        if (resName.indexOf('sq') > -1)
	            return 'sq';
	        return 'circle';
	    };
	    Effect.prototype.getShapeColor = function (resName) {
	        if (resName == 'circle1')
	            return 0xffca55;
	        if (resName == 'sq1')
	            return 0xfa7782;
	        if (resName == 'sq2')
	            return 0xf677ce;
	        if (resName == 'sq3')
	            return 0xffac84;
	        if (resName == 'sq4')
	            return 0xffca55;
	        if (resName == 'tri1')
	            return 0x2db0ee;
	        if (resName == 'tri2')
	            return 0x86e45f;
	        return 0xffca55;
	    };
	    return Effect;
	}());

	var PlayScene = (function (_super) {
	    tslib.__extends(PlayScene, _super);
	    function PlayScene() {
	        var _this = _super.call(this) || this;
	        _this.gravity = 1;
	        _this.timeSpeed = 1;
	        _this.INIT_BALL_NUMS = window['INIT_BALL_NUMS'];
	        _this.balls = [];
	        _this.pool = new Pool();
	        _this.blocks = [];
	        _this.velAmount = 25;
	        _this.directionAngle = 0;
	        _this.canShootTag = true;
	        _this.data = {
	            score: 0,
	            currentBallNums: 5,
	        };
	        _this.reviveTag = 0;
	        _this.INIT_BALL_NUMS = window['INIT_BALL_NUMS'] = 1;
	        _this.initEvents();
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.initScene, _this);
	        return _this;
	    }
	    PlayScene.prototype.initEvents = function () {
	        this.addEventListener(engine.Event.ENTER_FRAME, this.onEnterFrame, this);
	        this.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onTouchBegin, this);
	    };
	    PlayScene.prototype.removeEvents = function () {
	        this.removeEventListener(engine.MouseEvent.MOUSE_DOWN, this.onTouchBegin, this);
	        this.removeEventListener(engine.Event.ENTER_FRAME, this.onEnterFrame, this);
	    };
	    PlayScene.prototype.reset = function () {
	        var blocks = this.blocks.filter(function (block) { return !isSpecialBody(block) || block.type == "specialCircle"; });
	        for (var _i = 0, blocks_1 = blocks; _i < blocks_1.length; _i++) {
	            var block = blocks_1[_i];
	            this.removeEle(block, this.blocks);
	            block.view.parent && block.view.parent.removeChild(block.view);
	            this.pool.recover(block.type, block);
	        }
	    };
	    PlayScene.prototype.start = function () {
	        this.gamescore = 0;
	        this.currentBallNums = props.countDown;
	        this.startGame();
	    };
	    PlayScene.prototype.pausegame = function () {
	        this['pause'] = true;
	    };
	    PlayScene.prototype.resumegame = function () {
	        this['pause'] = false;
	    };
	    Object.defineProperty(PlayScene.prototype, "currentBallNums", {
	        get: function () {
	            return this.data.currentBallNums;
	        },
	        set: function (num) {
	            this.data.currentBallNums = num;
	            this.ballNums.text = num;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(PlayScene.prototype, "gamescore", {
	        get: function () {
	            return this.data.score;
	        },
	        set: function (num) {
	            this.data.score = num;
	            this.score.text = num;
	            engine.globalEvent.dispatchEvent('game-score-update', {
	                score: num,
	            });
	        },
	        enumerable: true,
	        configurable: true
	    });
	    PlayScene.prototype.initScene = function () {
	        this.initUI();
	        engine.Tween.get(this['ele1'], { loop: true }).set({ rotation: 0 }).to({ rotation: -360 }, 3000);
	        engine.Tween.get(this['ele2'], { loop: true }).set({ rotation: 0 }).to({ rotation: 360 }, 3000);
	        createSpecialRegTriangle(this, 60, 250, 200, 55, 'specialRegTriangleTop');
	        createSpecialRegTriangle(this, 750 - 60, 250, 200, -55, 'specialRegTriangleTop');
	        createSpecialRegTriangle(this, 150, 90, 500, 4, 'specialRegTriangleTop');
	        createSpecialRegTriangle(this, 750 - 150, 90, 500, -4, 'specialRegTriangleTop');
	        createSpecialRegTriangle(this, 230, 250, 40, 0, 'specialRegTriangleTop');
	        createSpecialRegTriangle(this, 750 - 230 + 5, 250, 40, 0, 'specialRegTriangleTop');
	        createSpecialRegTriangle(this, 170, 1271, 400, 52);
	        createSpecialRegTriangle(this, 750 - 170, 1271, 400, -52);
	        createSpecialRegTriangle(this, 232, 1351 - 3 - 5 - 3, 400, 30);
	        createSpecialRegTriangle(this, 750 - 232, 1351 - 3 - 5 - 3, 400, -30);
	        this.removeEventListener(engine.Event.ADDED_TO_STAGE, this.initScene, this);
	    };
	    PlayScene.prototype.initUI = function () {
	        this.score = new engine.Label();
	        this.score.x = 118;
	        this.score.y = 13;
	        this.score.size = 24;
	        this.score.fillColor = 0xffffff;
	        this.addChild(this.score);
	        this.ground = this.createSprite("地", 0, 1130);
	        this.ground.visible = true;
	        this.addChild(this.ground);
	        this.door = this.createSprite("door", 0, 68);
	        this.addChild(this.door);
	        this.ele1 = this.createSprite("风扇", 56, 1130, 20, 21);
	        this.addChild(this.ele1);
	        this.ele2 = this.createSprite("风扇", 698, 1130, 20, 21);
	        this.addChild(this.ele2);
	        var ele1_t = this.createSprite("风扇1", 54, 1078);
	        this.addChild(ele1_t);
	        var ele2_t = this.createSprite("风扇1", 693, 1078);
	        this.addChild(ele2_t);
	        this.shooter = this.createSprite("炮", 375, 222, 40, 40);
	        this.addChild(this.shooter);
	        this.ballNums = new engine.Label();
	        this.ballNums.x = 333;
	        this.ballNums.y = 203;
	        this.ballNums.width = 85;
	        this.ballNums.height = 43;
	        this.ballNums.textAlign = engine.TEXT_ALIGN.CENTER;
	        this.ballNums.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	        this.ballNums.size = 38;
	        this.ballNums.fillColor = 0x00ff00;
	        this.addChild(this.ballNums);
	        this.line = this.createSprite("shootline", 375, 222, 5, -74);
	        this.addChild(this.line);
	    };
	    PlayScene.prototype.createSprite = function (tname, x, y, anchorx, anchory) {
	        if (anchorx === void 0) { anchorx = 0; }
	        if (anchory === void 0) { anchory = 0; }
	        var sp = new engine.Image(getTextureByName(tname));
	        sp.x = x - anchorx;
	        sp.y = y - anchory;
	        sp.anchorX = anchorx;
	        sp.anchorY = anchory;
	        return sp;
	    };
	    PlayScene.prototype.setWindowData = function () {
	        window['numsP'] = 0.5;
	        window['INIT_BALL_NUMS'] = 1;
	    };
	    PlayScene.prototype.startGame = function () {
	        this.setWindowData();
	        this['pause'] = false;
	        this.reviveTag = 0;
	        resetCounter();
	        this.gamescore = 0;
	        this.ballCountAll = this.INIT_BALL_NUMS;
	        this.currentBallNums = this.ballCountAll;
	        this.balls.forEach(function (ball) { return ball.view.parent && ball.view.parent.removeChild(ball); });
	        this.balls = new Array();
	        for (var i = 0; i < this.INIT_BALL_NUMS; i++) {
	            var ball = createBallItem();
	            this.addChild(ball.view);
	            ball.view.y = this.shooter.y + 90 + this.shooter.anchorY - ball.view.anchorY;
	            ball.view.x = this.shooter.x + this.shooter.anchorX - ball.view.anchorX;
	            ball.view.visible = false;
	            this.balls.push(ball);
	        }
	        this.onShootEnd();
	    };
	    PlayScene.prototype.onGuildeTap = function () {
	        this['guide'].visible = false;
	        localStorage.setItem('guide', '1');
	    };
	    PlayScene.prototype.genBlocks = function () {
	        var _a = getBlocks(this.ballCountAll), blocksInfo = _a.blocksInfo, specialBallPosition = _a.specialBallPosition;
	        if (specialBallPosition > -1) {
	            createSpeialCircle(this, getLadderHPosition(specialBallPosition), getLadderPosition(LADDER_NUMS - 1), 0);
	        }
	        for (var _i = 0, blocksInfo_1 = blocksInfo; _i < blocksInfo_1.length; _i++) {
	            var block = blocksInfo_1[_i];
	            var position = block.position, type = block.type, nums = block.nums;
	            if (type == 1) {
	                createSquare(this, getLadderHPosition(position), getLadderPosition(LADDER_NUMS - 1), nums);
	            }
	            else if (type == 2) {
	                createRegTriangle(this, getLadderHPosition(position), getLadderPosition(LADDER_NUMS - 1), nums);
	            }
	            else {
	                createCircle(this, getLadderHPosition(position), getLadderPosition(LADDER_NUMS - 1), nums);
	            }
	        }
	    };
	    PlayScene.prototype.onTouchMove = function (e) {
	        var detaX = e.localX - 375;
	        var detaY = e.localY - 0;
	        if (detaY != 0) {
	            var angle = Math.atan(detaX / detaY);
	            if (angle > Math.PI / 180 * 75)
	                angle = Math.PI / 180 * 75;
	            if (angle < -Math.PI / 180 * 75)
	                angle = -Math.PI / 180 * 75;
	            this.line.rotation = this.shooter.rotation = -angle * radToDeg;
	            this.directionAngle = angle;
	            this.updateLine();
	        }
	    };
	    PlayScene.prototype.updateLine = function () {
	        this.line.scaleY = (1 - Math.abs(this.line.rotation) / 90 * 0.5);
	    };
	    PlayScene.prototype.onTouchEnd = function (e) {
	        if (this['pause'])
	            return;
	        this.removeEventListener(engine.MouseEvent.MOUSE_MOVE, this.onTouchMove, this);
	        this.canShootTag = false;
	        this.ballCount = 0;
	        this.ballShoot();
	    };
	    PlayScene.prototype.onTouchBegin = function (e) {
	        if (this['pause'])
	            return;
	        if (!this.canShootTag)
	            return;
	        this.line.visible = true;
	        this.addEventListener(engine.MouseEvent.MOUSE_MOVE, this.onTouchMove, this);
	        this.once(engine.MouseEvent.MOUSE_UP, this.onTouchEnd, this);
	        var detaX = e.localX - 375;
	        var detaY = e.localY - 0;
	        if (detaY != 0) {
	            var angle = Math.atan(detaX / detaY);
	            if (angle > Math.PI / 180 * 75)
	                angle = Math.PI / 180 * 75;
	            if (angle < -Math.PI / 180 * 75)
	                angle = -Math.PI / 180 * 75;
	            this.line.rotation = this.shooter.rotation = -angle * radToDeg;
	            this.directionAngle = angle;
	            this.updateLine();
	        }
	    };
	    PlayScene.prototype.onEnterFrame = function () {
	        Tween.flush();
	        for (var _i = 0, _a = this.balls; _i < _a.length; _i++) {
	            var ball = _a[_i];
	            if (ball.collideStatus == 3) ;
	            else {
	                for (var s = 0; s < this.timeSpeed; s++) {
	                    if (ball.collideStatus == 2) {
	                        ball.velocity.y += this.gravity;
	                    }
	                    ball.view.x += ball.velocity.x;
	                    ball.view.y += ball.velocity.y;
	                    if (ball.view.x < LEFT_GROUND) {
	                        ball.velocity.x *= -1 * getBounce();
	                        ball.view.x = LEFT_GROUND;
	                        ball.collideStatus = 2;
	                    }
	                    else if (ball.view.x + ball.view.width > RIGHT_GROUND) {
	                        ball.velocity.x *= -1 * getBounce();
	                        ball.view.x = RIGHT_GROUND - ball.view.width;
	                        ball.collideStatus = 2;
	                    }
	                    if (ball.view.y > 1200) {
	                        ball.velocity.x = 0;
	                        ball.velocity.y = this.velAmount;
	                        if (Math.random() > 0.5) {
	                            ball.view.y = 300;
	                            ball.view.x = 230 - BALL_D / 2;
	                        }
	                        else {
	                            ball.view.y = 300;
	                            ball.view.x = 750 - 230 + 5 - BALL_D / 2;
	                        }
	                    }
	                    for (var j = this.blocks.length - 1; j >= 0; j--) {
	                        var block = this.blocks[j];
	                        var normal = block.collideBall(ball);
	                        if (normal) {
	                            if (block instanceof Circle) {
	                                ball.velocity.symmetricFromNormalVector(normal);
	                                ball.velocity.x *= getBounce();
	                                ball.velocity.y *= getBounce();
	                                ball.collideStatus = 2;
	                            }
	                            else if (block instanceof RegTriangle) {
	                                if (block.type == 'specialRegTriangle') {
	                                    ball.collideStatus = 3;
	                                    this.recoverPath(ball);
	                                }
	                                else {
	                                    ball.velocity.symmetricFromNormalVector(normal);
	                                    ball.velocity.x *= getBounce();
	                                    ball.velocity.y *= getBounce();
	                                    ball.collideStatus = 2;
	                                }
	                            }
	                            else {
	                                ball.velocity.symmetricFromNormalVector(normal);
	                                ball.velocity.x *= getBounce();
	                                ball.velocity.y *= getBounce();
	                                ball.collideStatus = 2;
	                            }
	                            if (isSpecialBody(block)) {
	                                if (isSpecialCircle(block)) {
	                                    this.ballCountAll++;
	                                    playSound(SoundType.good);
	                                    var newball = createBallItem();
	                                    this.addChild(newball.view);
	                                    newball.view.y = ball.view.y = block.y;
	                                    newball.view.x = ball.view.x = block.x;
	                                    newball.collideStatus = 2;
	                                    this.balls.push(newball);
	                                    ball.velocity.x = 5;
	                                    newball.velocity.x = -5;
	                                    ball.velocity.y = newball.velocity.y = -20;
	                                    this.removeEle(block, this.blocks);
	                                    this.removeChild(block.view);
	                                    this.pool.recover(block.type, block);
	                                }
	                            }
	                            else {
	                                this.shake(block);
	                                this.gamescore += props.addscore;
	                                block.num = block.num - 1;
	                                playSound(SoundType.bounce);
	                                if (block.num <= 0) {
	                                    new Effect(block, this);
	                                    engine.Tween.removeTweens(block.view);
	                                    block.view.alpha = 1;
	                                    this.removeEle(block, this.blocks);
	                                    this.removeChild(block.view);
	                                    this.pool.recover(block.type, block);
	                                }
	                            }
	                        }
	                    }
	                }
	            }
	        }
	    };
	    PlayScene.prototype.removeEle = function (e, arr) {
	        var index = arr.indexOf(e);
	        if (index >= 0) {
	            arr.splice(index, 1);
	        }
	    };
	    PlayScene.prototype.shake = function (block) {
	        var startx = -block.view.bg.anchorX;
	        var starty = -block.view.bg.anchorY;
	        block.view.bg.x = startx - 2;
	        block.view.bg.y = starty - 2;
	        Tween.to(block.view.bg, 1, {
	            x: startx + 2,
	            y: starty + 2,
	            yoyo: 3,
	            useFrame: true,
	            onComplete: function () {
	                block.view.bg.x = startx;
	                block.view.bg.y = starty;
	            }
	        });
	    };
	    PlayScene.prototype.recoverPath = function (ball) {
	        var _this = this;
	        var time, targX;
	        if (ball.view.x > 375) {
	            var detaX = (RIGHT_GROUND - ball.view.x) / 20;
	            time = detaX < 1 ? 1 : detaX;
	            targX = RIGHT_GROUND;
	        }
	        else {
	            var detaX = (ball.view.x - LEFT_GROUND) / 20;
	            time = detaX < 1 ? 1 : detaX;
	            targX = LEFT_GROUND - BALL_D;
	        }
	        ball.view.alpha = 0.80;
	        Tween.to(ball.view, time, {
	            x: targX,
	            y: 1155,
	            useFrame: true,
	            onComplete: function () {
	                ball.view.x = targX;
	                playSound(SoundType.recover);
	                Tween.to(ball.view, 20, {
	                    y: 313.4 - 100,
	                    useFrame: true,
	                    onComplete: function () {
	                        var middlex = 375;
	                        var p0 = { x: ball.view.x, y: ball.view.y };
	                        var p1 = { x: (ball.view.x + middlex) / 2, y: ball.view.y - 500 };
	                        var p2 = { x: middlex, y: ball.view.y };
	                        Tween.to(ball.view, 20, {
	                            useFrame: true,
	                            __xx__: 100,
	                            onUpdate: function (value) {
	                                ball.view.x = (1 - value) * (1 - value) * p0.x + 2 * value * (1 - value) * p1.x + value * value * p2.x;
	                                ball.view.y = (1 - value) * (1 - value) * p0.y + 2 * value * (1 - value) * p1.y + value * value * p2.y;
	                            },
	                            onComplete: function () {
	                                _this.currentBallNums++;
	                                _this.ballCount++;
	                                ball.view.visible = false;
	                                ball.view.alpha = 1;
	                                if (_this.ballCount == _this.ballCountAll) {
	                                    _this.canShootTag = true;
	                                    _this.onShootEnd();
	                                }
	                            }
	                        });
	                    }
	                });
	            }
	        });
	    };
	    PlayScene.prototype.ballShoot = function () {
	        var _this = this;
	        this.onShootBegin();
	        var speedX = this.velAmount * Math.sin(this.directionAngle);
	        var speedY = this.velAmount * Math.cos(this.directionAngle);
	        var count = 0;
	        var timer = setInterval(function () {
	            count++;
	            playSound(SoundType.shoot);
	            _this.currentBallNums--;
	            if (_this.data.currentBallNums < 0)
	                _this.currentBallNums = 0;
	            if (count == _this.ballCountAll) {
	                clearInterval(timer);
	                _this['aceleTimer'] = setTimeout(function () {
	                    _this.timeSpeed = 3;
	                    _this['aceleTimer'] = 0;
	                }, ACELE_DELAY);
	            }
	            _this.balls[count - 1].collideStatus = 1;
	            _this.balls[count - 1].velocity.x = speedX;
	            _this.balls[count - 1].velocity.y = speedY;
	            var r = 90;
	            var rad = (_this.shooter.rotation * degToRad);
	            _this.balls[count - 1].view.x = _this.shooter.x - Math.sin(rad) * r + _this.shooter.anchorX - _this.balls[count - 1].view.anchorX;
	            _this.balls[count - 1].view.y = _this.shooter.y + Math.cos(rad) * r + _this.shooter.anchorY - _this.balls[count - 1].view.anchorY;
	            _this.balls[count - 1].view.visible = true;
	        }, 100);
	    };
	    PlayScene.prototype.onShootBegin = function () {
	        this.line.visible = false;
	    };
	    PlayScene.prototype.onShootEnd = function () {
	        if (this['aceleTimer'])
	            clearTimeout(this['aceleTimer']);
	        this.timeSpeed = 1;
	        this.line.visible = false;
	        this.currentBallNums = this.ballCountAll;
	        var blocks = this.blocks.filter(function (block) { return isSpecialCircle(block) || !isSpecialBody(block); });
	        var failed = false;
	        blocks.forEach(function (block) {
	            if (block.ladderNums >= 9) {
	                failed = true;
	            }
	        });
	        if (failed) {
	            this.checkGameOver();
	        }
	        else {
	            blocks.forEach(function (block) {
	                block.y -= getLadderGap();
	                block.ladderNums++;
	                if (block.ladderNums >= 9) {
	                    engine.Tween.get(block.view, { loop: true })
	                        .to({ alpha: 0 }, 1000 / 6)
	                        .to({ alpha: 1 }, 1000 / 6);
	                }
	            });
	            this.genBlocks();
	        }
	    };
	    PlayScene.prototype.checkGameOver = function () {
	        this['pause'] = true;
	        this.gameOver();
	    };
	    PlayScene.prototype.relive = function () {
	        this['pause'] = false;
	        var blocks = this.blocks.filter(function (block) { return (isSpecialCircle(block) || !isSpecialBody(block)) && block.ladderNums >= 5; });
	        for (var _i = 0, blocks_2 = blocks; _i < blocks_2.length; _i++) {
	            var block = blocks_2[_i];
	            this.gamescore += block.num;
	            this.removeEle(block, this.blocks);
	            block.view.parent && this.removeChild(block.view);
	            engine.Tween.removeTweens(block.view);
	            block.view.alpha = 1;
	            this.pool.recover(block.type, block);
	        }
	    };
	    PlayScene.prototype.gameOver = function () {
	        console.log("游戏结束");
	        engine.globalEvent.dispatchEvent('game-over', {});
	    };
	    Object.defineProperty(PlayScene.prototype, "skinKey", {
	        get: function () { return 'Play'; },
	        enumerable: true,
	        configurable: true
	    });
	    PlayScene.prototype.destroy = function () {
	        _super.prototype.destroy.call(this);
	    };
	    return PlayScene;
	}(engine.Container));

	var gameWrapper = (function (_super) {
	    tslib.__extends(gameWrapper, _super);
	    function gameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener("game-reset", _this.reset, _this);
	        engine.globalEvent.addEventListener("game-start", _this.start, _this);
	        engine.globalEvent.addEventListener("game-pause", _this.pause, _this);
	        engine.globalEvent.addEventListener("game-resume", _this.resume, _this);
	        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
	        return _this;
	    }
	    gameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        console.log("game-reset");
	        if (!this._gameView) {
	            this._gameView = new PlayScene();
	            this.addChild(this._gameView);
	        }
	        this._gameView.visible = true;
	        this._gameView.reset();
	    };
	    gameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        console.log("game-start");
	        this._status = 1;
	        this._gameView.start();
	    };
	    gameWrapper.prototype.pause = function () {
	        console.log("game-pause");
	        this._gameView.pausegame();
	    };
	    gameWrapper.prototype.resume = function () {
	        console.log("game-resume");
	        this._gameView.resumegame();
	    };
	    gameWrapper.prototype.clear = function () {
	        this._gameView.visible = false;
	    };
	    gameWrapper.prototype.onTap = function (event) {
	    };
	    return gameWrapper;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new gameWrapper();
	    return instance;
	}

	return index;

})));

//# sourceMappingURL=main.js.map