/**
 * Created by rockyl on 2020-01-21.
 */
import {IExposureData} from './IExposureData'
import {INetData} from './INetData'
import { GTime } from './GTime';

export function getTexture(uuid) {
	return engine.Texture.from(getAssetByUUID(uuid).uuid);
}

export function getTextureByName(name) {
	return getTexture(engine.getAssetByName(name).uuid);
}

export function playSound(name) {
	engine.playSound(engine.getAssetByName(name).uuid, {keep: true});
}
export function createSvga(name, anchorName?) {
	let inst = new svga.Svga();
	inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	return inst;
}

export function getIndexFromRC(row,col,maxCol){
	let index;
	index = row * maxCol + col ;
	return index
}




export function getRandomArray(array){
	array.sort(function() {
		return .5 - Math.random();
	});
}

/**
     * 兑吧点击埋点
     * @param {IExposureData} exposure
     */
    export function clickLog(exposure: IExposureData): void {
        const net: INetData = {
            name: 'clickLog',
            uri: '/log/click',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        send(net);
    }

    /**
     * 兑吧曝光埋点
     * @param {IExposureData} exposure
     */
    export function showLog(exposure: IExposureData): void {
        const net: INetData = {
            name: 'showLog',
            uri: exposure.domain + '/exposure/standard',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        send(net);
    }

    /**
     * 发送请求
     * @param net 
     */
    export function send(net: INetData): void {
        let gTime: string = '?_=' + GTime.getTimestamp();
        let realUrl: string = net.uri;
        if (realUrl.indexOf('?') != -1) {
            gTime = '&_=' + GTime.getTimestamp();
        }

        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }

        window['$'].ajax({
            type: net.type,
            // url: realUrl + gTime,
            url: realUrl,
            cache: false,
            dataType: net.dataType,
            data: net.param,
            async: true,
            // success: (result) => {
            //     this.onResponse(net, result);
            // },
            // error: (message) => {
            //     this.onError(net);
            // }
        });
    }

    