import {getTexture, createSvga, showLog, clickLog} from './utils'
import QAText from './QAText';
import {getlogItem} from './getlogItem';
import { props } from '../props';


export default class TestView extends engine.Container{
    worldTime:number;
    supermanImg:engine.Image;
    qaisOpen:boolean = false;
    QAText:QAText;
    breathSvga:svga.Svga;
    waveSvga:svga.Svga;
    rect:engine.Rect;

    constructor(){
        super()
        this.addEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
    }

    setup(){
        var that = this;
        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this)
        that.rect = new engine.Rect();
        that.rect.fillColor = "#000000";
        that.rect.alpha = 0.7;
        that.rect.width = 2000;
        that.rect.height = 2000;
        that.rect.visible = false;
        that.addChild(that.rect);
        that.breathSvga = createSvga("常规呼吸动作");
        that.waveSvga = createSvga("招手");
        that.waveSvga.visible = false;
        that.breathSvga.visible = true;
        that.breathSvga.mouseEnabled = that.waveSvga.mouseEnabled = true;
        that.addChild(that.breathSvga);
        that.addChild(that.waveSvga);
        that.breathSvga.x = that.waveSvga.x = engine.gameStage.stage.width - 178*0.7; 
        that.breathSvga.y = that.waveSvga.y = engine.gameStage.stage.height/3*2-60;
        that.breathSvga.gotoAndPlay(1);
        // that.breathSvga.scale = 0.6;
        // that.waveSvga.scale = 0.6;
        that.breathSvga.scaleX = that.breathSvga.scaleY = 0.7;
        that.waveSvga.scaleX = that.waveSvga.scaleY = 0.7;
        
        that.QAText = new QAText();
        that.addChild(that.QAText);
        that.QAText.setBigBgPositon(engine.gameStage.stage.width - that.QAText.getBigBgSize().w-35,engine.gameStage.stage.height/3*2-60 - that.QAText.getBigBgSize().h)
        that.QAText.setSmallBgPositon(engine.gameStage.stage.width - that.QAText.getSmallBgSize().w-35,engine.gameStage.stage.height/3*2-60 - that.QAText.getSmallBgSize().h)

        that.addEvnt();
    }

    addEvnt(){
        var that = this;
        // that.supermanImg.addEventListener(engine.MouseEvent.CLICK,that.touchSuperManImg,that);
        that.breathSvga.addEventListener(engine.MouseEvent.CLICK,that.touchSuperManImg,that);
        that.waveSvga.addEventListener(engine.MouseEvent.CLICK,that.touchSuperManImg,that);
        engine.globalEvent.addEventListener("pictures-ActLabel",that.showActLabelGroup,that);
        engine.globalEvent.addEventListener("pictures-supermanAnim",that.supermanAnim,that);
        engine.globalEvent.addEventListener("hideRect",()=>{that.rect.visible = false},that);
    }

    /**蛋黄超人动效 */
    supermanAnim(){

    }

    /**点击蛋黄超人 */
    touchSuperManImg(e:engine.MouseEvent){
        console.log("点击蛋黄超人")
        var that = this;
        if(that.QAText.visible) return;
        if(props.type == 0){
            clickLog(getlogItem(17))
        }else if(props.type == 1){
            clickLog(getlogItem(51))
        }
         //蛋黄超人动效
        that.showWaveSvga();
        that.QAText.showQLabelGroup(null);
        that.rect.visible = true;
    }

    /**展示互动文案组 */
    showActLabelGroup(e:engine.Event){
        var that = this;
        //蛋黄超人动效
        that.showWaveSvga();
        that.QAText.showActLabelGroup(parseInt(e.data.type))
    }

    showWaveSvga(){
        var that = this;
        that.breathSvga.visible = false;
        that.waveSvga.visible = true;
        that.waveSvga.play(false,false);
        that.waveSvga.once(engine.Event.END_FRAME,()=>{
            that.waveSvga.visible = false;
            that.breathSvga.gotoAndPlay(1)
            that.breathSvga.visible = true;
        },that)
    }


}