import Game from "./Game/Game";
import MTimer from "./Global/MTimer";
import { DataMgr } from "./Mgr/DataMgr";
import DebugMgr from "./Mgr/DebugMgr";
import FrameAnimation from "./Component/FrameAnimation";
import GuideMgr from "./Mgr/GuideMgr";
import { MConst } from "./Global/MConst";
import { NetUtils } from "./Global/NetUtils";
import Net from "./Global/Net";
import Loading from "./Global/Loading";
import { initNECaptcha } from "./Component/InitNECaptcha";

/**
 * Created by rockyl on 2019-11-22.
 */

export class ShootPlanet extends engine.Container {
	public game: Game = null;

	public onSleep() {
		this.game.destroy();
		this.game = null;
	}

	public onActive() {
		this.game = new Game(this);
		if (GuideMgr.instance.guideFlag == true) {
			const car = this.game._car;
			GuideMgr.instance.runGuide(0, car.x + car.width / 2, car.y + car.height / 2 /* - 130 */);
		}
	}

	constructor() {
		super();
		this.customProperty();
		this.width = 750;
		this.height = 1624;
		this.init();
	}

	private init() {
		Net.urlReplace();
		MTimer.init();
		DebugMgr.instance.init(this);
	}

	private customProperty() {
		window["RES"] = {
			getRes: function (uuid: string) {
				return engine.Texture.from(uuid);
			}
		};
		Math.clamp = function (target: number, min: number, max: number) {
			if (target > max) target = max;
			if (target < min) target = min;
			return target;
		}

		Object.defineProperty(engine.Point.prototype, 'length', {
			get: function () {
				return Math.sqrt(this.x * this.x + this.y * this.y);
			}
		});

		engine.DisplayObject.prototype.destroy = function () {
			this.parent.removeChild(this);
		}
	}
}
