import { Pool, PoolGroup } from "../Component/Pool";
import Drop from "../Game/Drop";

class DropPool extends Pool<Drop> {
    public spwan(id: number) {
        if (this.data.length > 0) {
            const element = this.data.shift();
            element.onElementInit();
            return element;
        } else {
            const d = new Drop(id);
            this.layer.addChild(d);
            return d;
        }
    }
}

export default class DropPoolGroup extends PoolGroup<Drop>{
    public spwan(id: string) {
        if (!this.data[id]) {
            this.data[id] = new DropPool(this.layer);
        }
        return this.data[id].spwan(id);
    }
}