import { Pool, PoolGroup } from "../Component/Pool";
import Ball from "../Game/Ball";
import { DataMgr } from "../Mgr/DataMgr";

class BallPool extends Pool<Ball>{
    public spwan(sizeIndex: number) {
        let element: Ball = null;
        if (this.data.length > 0) {
            element = this.data.shift();
            element.onElementInit();
        } else {
            element = new Ball(sizeIndex);
            this.layer.addChild(element);
        }
        DataMgr.game._ballList.push(element);
        return element;
    }

    public recycle(element: Ball) {
        super.recycle(element);
        DataMgr.game._ballList = DataMgr.game._ballList.filter(e => e !== element);
    }
};

export class BallPoolGroup extends PoolGroup<Ball>{

    public spwan(sizeIndex: number) {
        const key = sizeIndex.toString();
        if (!this.data[key]) {
            const ball =
                this.data[key] = new BallPool(this.layer)
        }
        let element = this.data[key].spwan(sizeIndex);
        element.poolKey = key;
        return element;
    }
}