import SoundMgr from "./SoundMgr";
import GuideMask from "../Game/GuideMask";
import { ShootPlanet } from "../ShootPlanet";
import { DataMgr } from "./DataMgr";


export default class GuideMgr {
    private static _instance: GuideMgr = null;
    public static get instance(): GuideMgr {
        if (!GuideMgr._instance) {
            GuideMgr._instance = new GuideMgr();
        }

        return GuideMgr._instance;
    }

    public get guideFlag(): boolean {
        return localStorage.getItem("guide") != "false";
    }
    public set guideFlag(v: boolean) {
        localStorage.setItem("guide", v ? "true" : "false");
    }

    private done: number[] = [];

    private currentGuideMask: GuideMask = null;
    public runGuide(index: number, x: number, y: number, end: boolean = false) {
        if (this.done[index] || this.guideFlag == false) return;
        this.done.push(index);
        DataMgr.game.pause = true;
        this.currentGuideMask = new GuideMask(index, x, y);
        this.currentGuideMask.onClick = (context) => {
            context.destroy();
            DataMgr.game.pause = false;

            if (end) {
                this.guideFlag = false;
            }
        };
        engine.gameStage.addChild(this.currentGuideMask);
    }
}