import Drop from "../Game/Drop";
import MTimer from "../Global/MTimer";
import GameMgr from "./GameMgr";

export default class DropBlinkMgr extends GameMgr {
    constructor() {
        super("DropBlinkMgr");
    }
    private list: {
        drop: Drop,
        count: number
    }[] = [];
    public add(drop: Drop) {
        this.list.push({
            drop: drop,
            count: 0
        });
    }
    public remove(drop: Drop) {
        this.list = this.list.filter(e => e.drop !== drop);
    }

    private frameTimer: number = 0;

    public onUpdate() {
        if (this.pause) return;

        if (this.frameTimer % BlinkDuration == 0) {
            let temp: {
                drop: Drop,
                count: number
            } = null;
            for (let i in this.list) {
                temp = this.list[i];
                temp.drop.visible = !temp.drop.visible;
                temp.count++;
            }
            this.list = this.list.filter(e => {
                if (e.count < 60 / BlinkDuration * 2) {
                    return true;
                } else {
                    e.drop.destroy();
                    return false;
                }

            });
        }
        this.frameTimer++;
    }
}

const BlinkDuration = 3;