import Net from "./Net";
import { MUtils } from "./MUtils";

export namespace NetUtils {
    export function encryptSeq(seq: number) {
        return Math.round(5 * seq - MUtils.random(0, 4));
    }

    export function md5(str: string) {
        return window['duiba_md5'](str);
    }
    export function getTimestamp() {
        return Date.now();
    }

    export function getCFG(): object {
        return window['CFG'];
    }

    const projectxString = "projectx/";
    export function getProjectId(): string {
        let windowUrl = window.location.href;
        let splitArr = windowUrl.split(projectxString);
        if (splitArr.length != 2) {
            return "projectId"
        }

        let start = windowUrl.indexOf(projectxString) + projectxString.length;
        let end = splitArr[1].indexOf("/");
        return windowUrl.substr(start, end);
    }
}