// export const MConfigs: any = window;
export namespace MConfigs {
    export function updateConfig() {
        let mconfig = window["mconfig"];
        if (typeof mconfig != "object") return;

        Object.keys(mconfig).forEach(e => {
            MConfigs[e] = mconfig[e];
        });
    }

    export const appId = "123";

    export const size = [0.3125, 0.5357, 0.7321, 1];
    export const drop: {
        [key: number]: {
            type: "bullet" | "power",
            value: number,
            textColor: number,
            fileIndex: string
        }
    } = {
        0: {
            type: "bullet",
            value: 1,
            textColor: 0x5dcefa,
            fileIndex: "0"
        },
        1: {
            type: "bullet",
            value: 2,
            textColor: 0x69e7fc,
            fileIndex: "1"
        },
        2: {
            type: "power",
            value: 30,
            textColor: 0xe83cf7,
            fileIndex: "2"
        },
        3: {
            type: "power",
            value: 20,
            textColor: 0xeb3924,
            fileIndex: "1"
        },
        4: {
            type: "power",
            value: 10,
            textColor: 0xfef552,
            fileIndex: "0"
        }
    }

    export const dropPool = {
        0: {
            num: 3,
            factor: {
                0: 40,
                1: 0,
                2: 0,
                3: 15,
                4: 50
            }
        },
        1: {
            num: 2,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        },
        2: {
            num: 1,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        }
    }

    export const props: {
        [key: string]: {
            id: string,
            type: 0 | 1
            value: number,
            name: string
        }
    } = {
        "sp_1": {
            id: "sp_1",
            type: 0,
            value: null,
            name: "复活卡"
        },
        "sp_2": {
            id: "sp_2",
            type: 1,
            value: 100,
            name: "1万分"
        },
        "sp_3": {
            id: "sp_3",
            type: 1,
            value: 200,
            name: "2万分"
        },
        "sp_4": {
            id: "sp_4",
            type: 1,
            value: 300,
            name: "3万分"
        },
        "sp_5": {
            id: "sp_5",
            type: 1,
            value: 600,
            name: "6万分"
        },
        "sp_6": {
            id: "sp_6",
            type: 1,
            value: 800,
            name: "8万分"
        }
    }

    /* export const boomEffectColor = [
        0xe41014,
        0xff9600,
        0x0090ff,
        0x8aff00,
        0xffe720
    ] */

    /**倒计时秒数 */
    export const countDown = 100;

    /**毫秒 */
    export const GameOverPanelStayTime = 60000;

    export const rewardList = [
        {
            rank: 1,
            url: ""
        },
        {
            rank: 2,
            url: ""
        },
        {
            rank: 3,
            url: ""
        },
        {
            rank: 4,
            url: ""
        },
        {
            rank: 5,
            url: ""
        }
    ]

    export const guide: {
        [key: number]: {
            mask: string,
            text: {
                str: string,
                offsetToMask: {
                    x: number,
                    y: number
                }
            }
        }
    } = {
        0: {
            mask: "guide_mask_0_png",
            text: {
                str: "左右移动炮车进行射击和躲避",
                offsetToMask: {
                    x: 8,
                    y: 290
                }
            }
        },
        1: {
            mask: "guide_mask_1_png",
            text: {
                str: "拾取金币可获得更多的炮弹输出和得分加成",
                offsetToMask: {
                    x: -65,
                    y: 290
                }
            }
        },
    }

    export const difficultyFactor = 0.1;

    export const lastRankListType = "20191104";

    export const rewardRecordUrl = "http://activity.m.duibatest.com.cn/projectx/p98a3fa4c/f09ba186f.html";

    export const onlineDate = "2019-10-31 14:50:49:123";

    export const urlMore = "http://www.baidu.com"

    export const wxRule = `结构一节将帮助你了解常见库的格式以及如何为每种格式
书写正确的声明文件。 如果你在编辑一个已经存在的文件，那么你可能不需要阅读此章节。 如果你在书写新的声明
文件，那么你必须阅读此章节以理解库的不同格式是如何影响声明文件的书写的。
结构一节将帮助你了解常见库的格式以及如何为每种格式书写正确的声明文件。 如果你在
编辑一个已经存在的文件，那么你可能不需要阅读此
章节。 如果你在书写新的声明文件，那么你必须阅读此章节以理解库的不同格式是如何影响
声明文件的书写的。`;

    export const appRule = `结构一节将帮助你了解常见库的格式以及如何为每种格式
书写正确的声明文件。 如果你在编辑一个已经存在的文件，那么你可能不需要阅读此章节。 如果你在书写新的声明
文件，那么你必须阅读此章节以理解库的不同格式是如何影响声明文件的书写的。
结构一节将帮助你了解常见库的格式以及如何为每种格式书写正确的声明文件。 如果你在
编辑一个已经存在的文件，那么你可能不需要阅读此
章节。 如果你在书写新的声明文件，那么你必须阅读此章节以理解库的不同格式是如何影响
声明文件的书写的。`

    export const share = {
        title: "分享标题",
        desc: "分享描述",
        imgUrl: "http://duiba.oss-cn-hangzhou.aliyuncs.com/db_games/activity/zhaohang_bill_2019/share.png",
        url: "http://activity-2.m.duiba.com.cn/customShare/share?id=3651"
    }

    export const toAppUrl = "http://www.baidu.com";

    export const wxMoreUrl = "http://www.baidu.com";
}






