import UILayer from "../Component/UILayer";
import MTimer from "./MTimer";

export default class Loading extends UILayer {
    private static _instance: Loading;
    private waitImg: engine.Sprite;
    private iconGroup: engine.Sprite = null;
    static get instace(): Loading {
        return Loading._instance || (Loading._instance = new Loading());
    }
    constructor() {
        super();
        let iconGroup = new engine.Sprite(RES.getRes("b15bd553-b54b-4cc9-85de-bc967eb4d485"));
        this.addChild(iconGroup);

        let waitImg = new engine.Sprite(RES.getRes("2c0f91d4-eed0-4df3-ac1f-7013d564927d"));
        waitImg.horizonCenter = 0;
        waitImg.verticalCenter = 0;
        iconGroup.addChild(waitImg);

        this.waitImg = waitImg;
        this.iconGroup = iconGroup;

        this.mouseEnabled = true;
        MTimer.onFrame("Loading", this.onEnterFrame, this);
    }

    show() {
        this.iconGroup.visible = true;
    }

    hide() {
        this.iconGroup.visible = false;
    }

    onEnterFrame() {
        if (this.visible) {
            this.waitImg.rotation += 5;
        }
    }
}
