import { MConst } from "../Global/MConst";
import { MConfigs } from "../Global/MConfigs";

export default class PlayerController extends engine.Container {
    public onTouchMove: (deltaX: number) => void = null;

    private touchId: number = null;
    private lastX: number = null;
    constructor() {
        super();
        this.width = MConst.DesignResolution.width;
        this.height = MConst.DesignResolution.height;

        this.addEventListener(engine.MouseEvent.MOUSE_DOWN, (e: engine.MouseEvent) => {
            this.touchId = e.instanceId;
            this.lastX = e.clientX;
        }, this);
        this.addEventListener(engine.MouseEvent.MOUSE_MOVE, (e: engine.MouseEvent) => {
            if (e.instanceId != this.touchId || this.touchId == null || this.lastX == null) return;

            this.onTouchMove && this.onTouchMove(e.clientX - this.lastX)
            this.lastX = e.clientX;
        }, this);
        this.addEventListener(engine.MouseEvent.MOUSE_UP, (e: engine.MouseEvent) => {
            if (e.instanceId != this.touchId) return;

            this.touchId = null;
            this.lastX = null;
        }, this);
        let rect = new engine.Rect();
        rect.width = 750;
        rect.height = 1624;
        rect.fillColor = "rgba(255,255,255,1)"
        rect.alpha = 0;
        this.addChild(rect);
    }
}