import { MConfigs } from "../Global/MConfigs";
import { MConst } from "../Global/MConst";

export default class GuideMask extends engine.Container {
    constructor(index: number, x1: number, y1: number) {
        super();
        const config = MConfigs.guide[index];

        let mask = new engine.Sprite(RES.getRes("3cc0aa86-0581-4caa-b662-266e58fd39b7"));
        x1 = Math.floor(x1);
        y1 = Math.floor(y1);
        const x = x1 - 320 / 2;
        const y = y1 - 290 / 2;
        mask.x = x;
        mask.y = y;
        this.addChild(mask);

        const w = mask.width, h = mask.height;
        const sw = MConst.DesignResolution.width, sh = MConst.DesignResolution.height;

        let top = new engine.Shape();
        top.beginFill(0x01103a, 0.8);
        top.drawRect(0, 0, sw, y);
        top.endFill();
        this.addChild(top);

        let bottom = new engine.Shape();
        bottom.beginFill(0x01103a, 0.8);
        bottom.drawRect(x, y + h, w, sh - h - y);
        bottom.endFill();
        this.addChild(bottom);

        let left = new engine.Shape();
        left.beginFill(0x01103a, 0.8);
        left.drawRect(0, y, x, sh - y);
        left.endFill();
        this.addChild(left);

        let right = new engine.Shape();
        right.beginFill(0x01103a, 0.8);
        right.drawRect(x + w, y, sw - x - w, sh - y);
        right.endFill();
        this.addChild(right);

        let offsetToMask = config.text.offsetToMask;
        let label = new engine.Label();
        label.text = config.text.str;
        label.size = 24;
        label.fillColor = "rgba(255,255,255,1)";
        label.x = offsetToMask.x + mask.x;
        label.y = offsetToMask.y + mask.y;
        this.addChild(label);


        if (index == 0) {
            let left = new engine.Sprite(RES.getRes("93992a62-e3c4-46d5-99f4-f7ba35fe4f4f"));
            left.x = x1 + 200;
            left.y = y1 - left.height / 2;
            this.addChild(left);

            let right = new engine.Sprite(RES.getRes("93992a62-e3c4-46d5-99f4-f7ba35fe4f4f"));
            right.x = x1 - 200;
            right.scaleX = -1;
            right.y = y1 - right.height / 2;
            this.addChild(right);
        }


        if (label.x < 0) {
            label.x = 0;
        } else if (label.x + label.width > 750) {
            label.x = 750 - label.width;
        }

        this.addEventListener(engine.MouseEvent.MOUSE_DOWN, () => {
            this.onClick && this.onClick(this);
        }, this);
    }

    onClick: (context: GuideMask) => void;
}