import MoveObjcet from "./MoveObject";
import { MConfigs } from "../Global/MConfigs";
import Collider, { ColliderGroup, PointCollider } from "../Phycics/Collider";
import SoundMgr from "../Mgr/SoundMgr";
import { PoolElement } from "../Component/Pool";
import { DataMgr } from "../Mgr/DataMgr";

const dropImgNames = [
    "f7221f86-f376-40ce-b0e8-f7ea573ec780",
    "c9dbd728-1844-4910-b1ef-e84ce10dc422",
    "41182131-7050-4b95-9dce-45275b70738d",
    "17d8e000-b290-4972-bcab-cb819a6cf51b",
    "3f7faebf-64da-44a4-8152-0c35fcc29fe5"
];

export default class Drop extends MoveObjcet implements PoolElement {
    private type: "bullet" | "power" = null;
    private label: engine.Label = null;
    public bitmap: engine.Image = null;
    private scoreValue: number = null;
    private collider: PointCollider = null;
    private isGround: boolean = false;
    private stayGroundCount = 0;
    private id: number = null;

    constructor(id: number) {
        super();
        this.id = id;
        //图像
        let bitmap = new engine.Image();
        this.addChild(bitmap);
        this.bitmap = bitmap;

        //文字
        let label = new engine.Label();
        label.size = 24;
        this.addChild(label);
        this.label = label;
        this.collider = this.addComponent<PointCollider>(PointCollider);
        this.collider.group = ColliderGroup.Drop;

        const config = MConfigs.drop[id];
        this.type = config.type;
        this.scoreValue = config.value;
        this.physics.acceleration.y = 0.3;

        let texture = RES.getRes(dropImgNames[id]) as engine.Texture;
        this.bitmap.texture = texture;

        let str = "+" + config.value;
        if (config.type == "power") str = str + "%";
        label.text = str;
        label.fillColor = config.textColor;
        label.visible = false;
        label.x = texture.width + 2;
        label.y = texture.height / 2 - label.height / 2;

        this.collider.setData(texture.width / 2, texture.height / 2);
    }

    private eated() {
        SoundMgr.instance.playEffect("collect");
        this.physics.rotateVelocity = 0;
        DataMgr.game._dropBlinkMgr.remove(this);
        this.visible = true;
        this.rotation = 0;
        this.physics.enabled = false;
        this.getComponent(PointCollider).enabled = false;
        this.label.visible = true;
        if (this.type == "bullet") {
            DataMgr.game._BulletScore += this.scoreValue;
        } else if (this.type == "power") {
            DataMgr.game._PowerScore += this.scoreValue;
        }

        const tweenMgr = DataMgr.game._tweenMgr;

        tweenMgr.removeTweens(this);
        tweenMgr.get(this)
            .to({ y: this.y - 200, alpha: 0 }, 1000, false)
            .call(() => {
                DataMgr.game._pool.drop.recycle(this.id.toString(), this);
                tweenMgr.removeTweens(this);
            });
    }

    onCollisionEnter(other: Collider) {
        if (other.group == ColliderGroup.Car) {
            this.eated();
        }

        if (other.group == ColliderGroup.Ground && !this.isGround) {
            this.stayGroundCount = 0;
            this.physics.velocity.y = -(this.physics.velocity.y * 0.4);
        }

        if (other.group == ColliderGroup.Wall) {
            this.physics.velocity.x = - this.physics.velocity.x;
            if (this.isGround) {
                this.physics.rotateVelocity = -this.physics.rotateVelocity
            }
        }
    }

    onCollisionStay(other: Collider) {
        if (other.group == ColliderGroup.Ground && !this.isGround) {
            this.stayGroundCount++;
            if (this.stayGroundCount > 2) {
                this.isGround = true;
                this.physics.velocity.y = 0;
                this.physics.acceleration.y = 0;
                this.physics.velocity.x *= 0.5;
                DataMgr.game._dropBlinkMgr.add(this);

                this.physics.rotateVelocity = this.physics.velocity.x * (180 / (Math.PI * 13));
            }
        }
    }

    onCollisionExit(other: Collider) {
        if (other.group == ColliderGroup.Ground) {
            this.stayGroundCount = 0;
        }
    }

    onElementInit() {
        this.visible = true;
        this.stayGroundCount = 0;
        this.isGround = false;
        this.enableAllComponents();
        this.label.visible = false;
        this.physics.acceleration.y = 0.3;
    }

    onElementRecycle() {
        this.alpha = 1;
        this.visible = false;
        this.disableAllComponents();
    }
}