import GameObject from "./GameObject";
import Collider, { RectCollider, ColliderGroup } from "../Phycics/Collider";
import { MConst } from "../Global/MConst";
import Bullet, { BulletGroup } from "./Bullet";
import SoundMgr from "../Mgr/SoundMgr";
import MTimer from "../Global/MTimer";
import Game from "./Game";
import { DataMgr } from "../Mgr/DataMgr";



export default class Car extends GameObject {
    private imgParticel: engine.Sprite = null;
    private fireTimer: number = null;
    public touchWall: 1 | -1 | 0 = 0;
    public onDied: () => void;
    private isDied: boolean = false;
    private fireParticleTimer = 0;
    private invincibleDuration = 0;

    /**每排子弹的个数 */
    private rowBulletNum: number = 1;
    private fireSpeed: number = MConst.BulletFireSpeed.min;

    constructor() {
        super();
        // this.x = 124;
        // this.y = 145;

        let sprite = new engine.Sprite(RES.getRes("ddf5128e-be66-4c00-8505-e4167aac37bc"));
        sprite.x = 0;
        sprite.y = 16;
        this.addChild(sprite);
        /* this.createPart("30fd41be-d702-4511-93d8-5f4609ea4c7d", 4.96, 138.69);
        this.createPart("6211fb97-ba4a-4b79-b178-09dcf63c16d4", 12.5, 102.5);
        this.imgGun = this.createPart("fbd26824-9f87-4784-b825-1d824de97023", 33.5, 20);
        this.createPart("83144d98-b464-48d2-95ac-5b189f134ba7", 0, 97.5);
         */
        let particle = new engine.Sprite(RES.getRes("d8daa113-0d75-4139-9e81-c54b7522c890"));
        particle.x = 31;
        particle.y = 0;
        this.addChild(particle);
        this.imgParticel = particle;
        MTimer.onFrame("Car", this.onUpdate, this);
        let collider = this.addComponent<RectCollider>(RectCollider);
        collider.setData(41, 13, 65, 129);
        collider.group = ColliderGroup.Car;
    }

    /* private createPart(source: string, x: number, y: number) {
        let bitmap = new engine.Image(RES.getRes(source) as engine.Texture);
        bitmap.x = x;
        bitmap.y = y;
        this.addChild(bitmap);
        return bitmap;
    } */

    private fire() {
        // return;
        SoundMgr.instance.playEffect("shoot");
        new BulletGroup(new engine.Point(this.x + this.width / 2, this.y), this.rowBulletNum);
    }

    private die() {
        if (this.isDied) return;
        this.isDied = true;
        if (this.invincibleDuration > 0) return;

        this.onDied && this.onDied();
    }

    onCollisionEnter(other: Collider) {
        if (other.group == ColliderGroup.Ball) {
            this.die();
        }

        if (other.group == ColliderGroup.Wall) {
            this.touchWall = other.owner.x < 0 ? 1 : -1;

        }
    }

    onCollisionStay(other: Collider) {
        if (other.group == ColliderGroup.Ball) {
            this.die();
        }

        if (other.group == ColliderGroup.Wall) {
            this.touchWall = other.owner.x < 0 ? 1 : -1;

        }
    }

    private onceBlink() {
        DataMgr.game._tweenMgr.get(this)
            .to({ alpha: 0 }, 1, true)
            .wait(2)
            .to({ alpha: 1 }, 1, true)
            .wait(2)
            .call(() => { this.onceBlink(); });
    }

    revive() {
        this.invincibleDuration = MConst.ReviveInvincibleDuration * 1000;
        DataMgr.game._tweenMgr.removeTweens(this);
        this.onceBlink();
        MTimer.setFrameTimer(MConst.ReviveInvincibleDuration * 60, () => {
            //无敌结束
            this.alpha = 1;
            DataMgr.game._tweenMgr.removeTweens(this);
        });
    }

    move(deltaX: number) {
        if (this.touchWall == 1 && deltaX <= 0) {
            return;
        } else if (this.touchWall == -1 && deltaX >= 0) {
            return;
        }
        this.x += deltaX;
    }

    onCollisionExit(other: Collider) {
        if (other.group == ColliderGroup.Wall) {
            this.touchWall = 0;
        }
    }

    private onUpdate() {
        if (DataMgr.game.pause) return;

        const score = DataMgr.game.bulletScore;
        //更新开火速度
        if (score <= 20) {
            const max = MConst.BulletFireSpeed.max;
            const min = MConst.BulletFireSpeed.min;
            this.fireSpeed = min + (max - min) * (score / 20);
        } else {
            this.fireSpeed = MConst.BulletFireSpeed.max;
        }
        //更新子弹排数
        this.rowBulletNum = Math.ceil((Math.clamp(score, 15, 140) / 2) / 10);

        //无敌计时器流逝
        if (this.invincibleDuration > 0) {
            this.invincibleDuration -= MTimer.deltaTime;
        }
        //开火计时流逝
        this.fireTimer += 1 * MTimer.dtFactor;

        if (this.fireTimer >= 60 / this.fireSpeed) {
            this.fire();
            this.fireTimer = 0;
        }
        if (this.fireParticleTimer % 3 == 0) {
            this.imgParticel.visible = !this.imgParticel.visible;
        }

        this.fireParticleTimer++;
    }
}