export abstract class PoolGroup<T extends PoolElement>{
    constructor(protected layer: engine.Container) { }
    protected data: { [key: string]: Pool<T> } = {}
    public recycle(key: string, element: T) {
        this.data[key].recycle(element);
    }

    public abstract spwan(...args: any[]): T;
}

export abstract class Pool<T extends PoolElement>{
    constructor(protected layer: engine.Container) { }

    protected data: T[] = [];

    public recycle(element: T) {
        element.onElementRecycle();
        this.data.push(element);
    }

    public abstract spwan(...args: any[]): T;
}

export interface PoolElement {
    /**回收元素时的调用 */
    onElementRecycle(): void;
    onElementInit(): void;
    poolKey?: string;
}