try {
    const props = {
        lastToggle: target.findChildByUUID("6c82c9b8-361d-42d5-9c0d-0bb332bbdbeb"),
        curToggle: target.findChildByUUID("86bb17dc-df9e-4900-802d-e5636390a222"),
        lastBg: target.findChildByUUID("be83b6ae-bf67-4cb5-8cad-19521512b7e6"),
        curBg: target.findChildByUUID("25e76897-655b-49eb-b536-28b7123d6558"),
        lastTitle: target.findChildByUUID("24c2e89a-0885-40fc-b37c-b6ca38a8824a"),
        curTitle: target.findChildByUUID("cabd2593-c197-46ee-b747-deb26923bd18"),
        scroller: target.getChildByName("scrollList"),

        myNickname: target.getChildByNamePath("我的信息组/我的昵称"),
        myIndex: target.getChildByNamePath("我的信息组/我的排名"),
        myScore: target.getChildByNamePath("我的信息组/我的分数"),
        tip: target.parent.getChildByName("提示"),
        noOpenGroup: target.parent.getChildByName("未开奖组"),
        winningGroup: target.parent.getChildByName("中奖组"),
        notWinnintGroup: target.parent.getChildByName("未中奖组"),
        winningTip: target.parent.getChildByNamePath("中奖组/中奖提示")
    }

    //数据
    let dataList1 = [];
    for (let i = 0; i <= 200; i++) {
        dataList1.push({
            rank: i + 1,
            nickname: "我是昵称",
            score: 12138
        });
    }

    let dataList2 = [];
    for (let i = 0; i <= 50; i++) {
        dataList2.push({
            rank: i + 1,
            nickname: "沙雕12138",
            score: 11122255
        });
    }

    //target.curData = [];
    //target.lastData = [];

    /**
     * @param toggle
     * @param {Array} listData
     * @param { index:number, nickname:string, maxScore:number } myData
     */
    target.onToggle = function (toggle, listData, myData, isNull) {
        if (toggle === target.selection) {
            return;
        }

        target.selection = toggle;

        const resData = global.dataCenter.getDataByPath("rankList");

        props.noOpenGroup.visible = false;
        props.notWinnintGroup.visible = false;
        props.winningGroup.visible = false;

        if (toggle === props.lastToggle) { //选中上期
            props.lastBg.visible = true;
            props.curBg.visible = false;
            props.lastTitle.fillColor = "rgba(255, 255, 255, 1)";
            props.curTitle.fillColor = "rgba(244, 129, 89, 1)";

            if (resData.winData.isWin.length > 0) {
                switch (resData.winData.isWin) {
                    case "0": //未中奖
                        props.notWinnintGroup.visible = true;
                        break;
                    case "1": //中奖
                        props.winningGroup.visible = true;
                        props.winningTip.text = "恭喜你中奖了！";
                        break;
                    case "2": //中奖
                        props.winningGroup.visible = true;
                        props.winningTip.text = "很遗憾未中奖！";
                        break;
                }
            } else {
                props.noOpenGroup.visible = true;
                props.winningTip.visible = false;
            }

            if (!isNull) {
                if (resData.currentFirstFlag) {
                    props.tip.text = "暂无数据";
                    props.tip.visible = true;
                    props.winningGroup.visible = false;
                    props.notWinnintGroup.visible = false;
                    props.noOpenGroup.visible = false;
                    myData = {}
                    listData = []
                } else if (listData.length <= 0) {
                    props.tip.text = "快去玩游戏赢大奖吧~";
                    props.tip.visible = true;
                    myData = {}
                    props.winningGroup.visible = false;
                    props.notWinnintGroup.visible = false;
                    props.noOpenGroup.visible = false;
                    listData = []
                } else {
                    props.tip.visible = false;
                }
            } else {
                props.tip.visible = false;
            }
        } else if (toggle === props.curToggle) {
            props.curTitle.fillColor = "rgba(255, 255, 255, 1)";
            props.lastTitle.fillColor = "rgba(244, 129, 89, 1)";
            props.lastBg.visible = false;
            props.curBg.visible = true;
            props.noOpenGroup.visible = true;

            if (!isNull) {
                if (global.dataCenter.getDataByPath("visit.finishedStatus") == true) {
                    props.tip.text = "活动已结束，敬请期待更多精彩内容";
                    props.tip.visible = true;
                    props.noOpenGroup.visible = false;
                    myData = {}
                    listData = []
                } else if (listData.length <= 0) {
                    props.tip.text = "快去玩游戏赢大奖吧~";
                    props.tip.visible = true;
                    props.noOpenGroup.visible = false;
                    myData = {}
                    listData = []
                } else {
                    props.tip.visible = false;
                }
            } else {
                props.tip.visible = false;
            }
        }


        //替换emoji
        for (let i = 0; i < listData.lenght; i++) {
            if (listData[i].userId.toString() == myData.userId) {
                listData[i].nickname = myData.nickName
                break;
            }
        }

        props.scroller.setData(listData);

        props.myNickname.text = limitText(myData.nickName, 12);
        props.myIndex.text = rankText(myData.index);
        props.myScore.text = scoreText(myData.maxScore);
    }
    target.selection = null;
    target.onToggle(props.curToggle, [], {}, true);
    target.selection = null;
    props.scroller.viewPort.y = 0;
    props.curToggle.dispatchEvent(engine.MouseEvent.CLICK);

} catch (error) {
    console.error(error);
}

function scoreText(score) {
    if (typeof score == "undefined")
        return "";

    if (typeof score != "number") {
        return "0";
    }
    return limitText(score, 7);
}

function rankText(rank) {
    if (typeof rank == "undefined")
        return "";

    if (typeof rank != "number") {
        return "1000+";
    }

    if (rank > 1000) {
        return "1000+";
    }

    return rank.toString();
}

next("success");