/**
 * Created by rockyl on 2020-01-02.
 */

export function getTexture(uuid: string): engine.Texture {
	let config = getAssetByUUID(uuid);
	return engine.Texture.from(config ? config.uuid : uuid);
}

export function getAsset(uuid: string) {
	let config = getAssetByUUID(uuid);
	return engine.globalLoader.get(config.uuid);
}

export function clamp(target: number, min: number, max: number) {
	return Math.min(max, Math.max(min, target));
}
