import Game from "./Game/Game";
import MTimer from "./Global/MTimer";
import DebugMgr from "./Mgr/DebugMgr";
import GuideMgr from "./Mgr/GuideMgr";

/**
 * Created by rockyl on 2019-11-22.
 */

export class ShootPlanet extends engine.Container {
	public game: Game = null;

	constructor() {
		super();
		this.customProperty();
		this.width = 750;
		this.height = 1624;
		this.init();

		engine.globalEvent.addEventListener('game-create', this.onActive, this);
		engine.globalEvent.addEventListener('game-destroy', this.onSleep, this);
		engine.globalEvent.addEventListener('game-revive', this.onRevive, this);
		engine.globalEvent.addEventListener('game-pause', this.onPause, this);
		engine.globalEvent.addEventListener('game-resume', this.onResume, this);
	}

	public onActive() {
		if(!this.game){
			this.game = new Game(this);
		}
		if (GuideMgr.instance.guideFlag == true) {
			const car = this.game._car;
			GuideMgr.instance.runGuide(0, car.x + car.width / 2, car.y + car.height / 2 /* - 130 */);
		}
		if (GuideMgr.instance.guideDone) {
			this.game.onGuideDone();
		}
	}

	public onSleep() {
		this.game.destroy();
		this.game = null;
	}

	public onRevive() {
		this.game.revive();
	}

	public onPause() {
		this.game.pause = true;
	}

	public onResume() {
		this.game.pause = false;
	}

	private init() {
		MTimer.init();
		DebugMgr.instance.init(this);
	}

	private customProperty() {
		Object.defineProperty(engine.Point.prototype, 'length', {
			get: function () {
				return Math.sqrt(this.x * this.x + this.y * this.y);
			}
		});

		engine.DisplayObject.prototype.dispose = function () {
			this.parent.removeChild(this);
		}
	}
}
