import FrameAnimation from "../Component/FrameAnimation";
import { Pool, PoolGroup, PoolElement } from "../Component/Pool";

export class PoolFrameAnimation extends FrameAnimation implements PoolElement {
    onElementInit() {
        this.visible = true;
        this.curPos = 0;
    }
    onElementRecycle() {
        this.visible = false;
    }
}

class AnimationPool extends Pool<PoolFrameAnimation> {
    public spwan(key: string): PoolFrameAnimation {
        if (this.data.length > 0) {
            const element = this.data.shift();
            element.onElementInit();
            return element;
        } else {
            let anim = new PoolFrameAnimation(key);
            this.layer.addChild(anim);
            return anim;
        }
    }
}

export default class AnimationPoolGroup extends PoolGroup<PoolFrameAnimation> {
    public spwan(key: string) {
        if (!this.data[key]) {
            this.data[key] = new AnimationPool(this.layer);
        }
        const element = this.data[key].spwan(key);
        return element;
    }
}