import {getTexture} from "../utils";

type ImgType = "star" | "ring" | "fireworks_line_0" | "fireworks_line_1";
export namespace TextureMgr {
    const uuids: {
        [key in ImgType]: string[]
    } = {
        "star": [
            "e79f4e51-dbca-45fb-b95a-f52a708e0990",
            "1a1b529f-bf68-42cb-8a3e-01b21119b322",
            "999d65ba-f7c8-4939-9868-5f974a278752",
            "c5743fdf-aadf-4139-b03a-cfd047f85220",
            "2aaa2535-d4b9-44c4-8fc2-700c8310e534"
        ],
        "ring": [
            "b3c78176-5650-4d49-bc00-cfaf048c5940",
            "134e2eec-e393-4ba3-b8cc-f72270bf17c2",
            "49092176-3b1c-4ea5-8e02-6050fc5809dd",
            "15c46813-ac79-4c5f-8a52-e8cded6dadff",
            "64e64fd6-0426-493e-b003-dcafc7e06eb5"
        ],
        "fireworks_line_0": [
            "c76f6d87-7f84-45ed-a9ac-cf8d4dd47026",
            "1fc4fb96-73b7-4250-8886-3c6976eb1139",
            "65be7718-f6cd-44d9-89d0-5daf81068316"
        ],
        "fireworks_line_1": [
            "10901339-4976-4d38-a3b9-47b7e9025144",
            "0692b423-6f14-4ba7-884a-7c177f1583c8",
            "2ddd9477-12de-4f13-bb35-5b255f1624bd"
        ]
    };

    /* const caches: {
        [uuid: string]: engine.Texture
    } = {}; */

    export function get(type: ImgType, index: number) {
        const uuid = uuids[type][index];
        /* if (!caches[uuid]) {
            caches[uuid] = ;
        } */
        return getTexture(uuid);
    }
}