import MTimer from "../Global/MTimer";

export default class SoundMgr {
	private static _instance: SoundMgr = null;
	public static get instance(): SoundMgr {
		if (!this._instance) {
			this._instance = new SoundMgr();
		}

		return this._instance;
	}

	public get enabled() {
		return engine.env.soundEnabled;
	}

	public playEffect(name: string, loop: boolean = false) {
		if (!this.enabled) return;

		engine.playSound(getAssetByUUID(nameToUuid[name]).uuid, {
			loop: false,
			keep: true
		}, name);
	}


}

const nameToUuid = {
	shoot: "b01dc39a-2886-4887-b3bb-0f8c801003a9",
	collect: "7004616a-0aba-4826-9245-895e7fdf8d31",
	dong: "7fc04e43-1465-4336-92a3-d6039ee88cb3",
	boom: "ca6b799f-be85-4e94-99df-812f31801490"
}