import {props} from "../../props";
import GuideMask from "../Game/GuideMask";
import { ShootPlanet } from "../ShootPlanet";
import { DataMgr } from "./DataMgr";
import {MConfigs} from "../Global/MConfigs";


export default class GuideMgr {
    private static _instance: GuideMgr = null;
    public static get instance(): GuideMgr {
        if (!GuideMgr._instance) {
            GuideMgr._instance = new GuideMgr();
        }

        return GuideMgr._instance;
    }

    public get guideFlag(): boolean {
        return localStorage.getItem("shoot-planet_" + props.guideFlagKey) != "false";
    }
    public set guideFlag(v: boolean) {
        localStorage.setItem("shoot-planet_" + props.guideFlagKey, v ? "true" : "false");
    }

    set container(c){
        this._container = c;
    }

    private done: number[] = [];
    private _container: engine.Container;

    get guideDone(){
        return !this.guideFlag || this.done.length >= Object.keys(MConfigs.guide).length;
    }

    private currentGuideMask: GuideMask = null;
    public runGuide(index: number, x: number, y: number, end: boolean = false) {
        if (this.done[index] || this.guideFlag == false) return;
        this.done.push(index);
        DataMgr.game.pause = true;
        this.currentGuideMask = new GuideMask(index, x, y);
        this.currentGuideMask.onClick = (context) => {
            context.dispose();
            DataMgr.game.pause = false;

            if(this.done.length >= Object.keys(MConfigs.guide).length){
                DataMgr.game.onGuideDone();
            }

            if (end) {
                this.guideFlag = false;
            }
        };
        this._container.addChild(this.currentGuideMask);
    }
}