// export const MConfigs: any = window;
export namespace MConfigs {
	export function updateConfig() {
		let mconfig = window["mconfig"];
		if (typeof mconfig != "object") return;

		Object.keys(mconfig).forEach(e => {
			MConfigs[e] = mconfig[e];
		});
	}

	export const size = [0.3125, 0.5357, 0.7321, 1];
	export const drop: {
		[key: number]: {
			type: "bullet" | "power",
			value: number,
			textColor: number,
			fileIndex: string
		}
	} = [
		{
			type: "bullet",
			value: 1,
			textColor: 0x5dcefa,
			fileIndex: "0"
		},
		{
			type: "bullet",
			value: 2,
			textColor: 0x69e7fc,
			fileIndex: "1"
		},
		{
			type: "power",
			value: 30,
			textColor: 0xe83cf7,
			fileIndex: "2"
		},
		{
			type: "power",
			value: 20,
			textColor: 0xeb3924,
			fileIndex: "1"
		},
		{
			type: "power",
			value: 10,
			textColor: 0xfef552,
			fileIndex: "0"
		}
	]

	export const dropPool = {
		0: {
			num: 3,
			factor: {
				0: 40,
				1: 0,
				2: 0,
				3: 15,
				4: 50
			}
		},
		1: {
			num: 2,
			factor: {
				0: 40,
				1: 0,
				2: 5,
				3: 15,
				4: 50
			}
		},
		2: {
			num: 1,
			factor: {
				0: 40,
				1: 0,
				2: 5,
				3: 15,
				4: 50
			}
		}
	}

	/* export const boomEffectColor = [
			0xe41014,
			0xff9600,
			0x0090ff,
			0x8aff00,
			0xffe720
	] */

	export const guide: {
		[key: number]: {
			mask: string,
			text: {
				str: string,
				offsetToMask: {
					x: number,
					y: number
				}
			}
		}
	} = {
		0: {
			mask: "guide_mask_0_png",
			text: {
				str: "左右移动炮车进行射击和躲避",
				offsetToMask: {
					x: 8,
					y: 290
				}
			}
		},
		1: {
			mask: "guide_mask_1_png",
			text: {
				str: "拾取金币可获得更多的炮弹输出和得分加成",
				offsetToMask: {
					x: -65,
					y: 290
				}
			}
		},
	}
}






