import {MConfigs} from "../Global/MConfigs";
import {MConst} from "../Global/MConst";
import {getTexture} from "../utils";
import {props} from "../../props";

const padding = 10;

export default class GuideMask extends engine.Container {
	constructor(index: number, x1: number, y1: number) {
		super();
		const config = MConfigs.guide[index];

		let mask = new engine.Sprite(getTexture("3cc0aa86-0581-4caa-b662-266e58fd39b7"));
		const w = mask.width, h = mask.height;

		x1 = Math.floor(x1);
		y1 = Math.floor(y1);
		const x = x1 - w / 2;
		const y = y1 - h / 2;
		mask.x = x;
		mask.y = y;
		this.addChild(mask);

		const sw = MConst.DesignResolution.width, sh = MConst.DesignResolution.height;
		
		let color = 0x000000;
		let alpha = 0.7;

		let top = new engine.Shape();
		top.beginFill(color, alpha);
		top.drawRect(0, -sh, sw, y + sh);
		top.endFill();
		this.addChild(top);

		let bottom = new engine.Shape();
		bottom.beginFill(color, alpha);
		bottom.drawRect(x, y + h, w, sh - h - y);
		bottom.endFill();
		this.addChild(bottom);

		let left = new engine.Shape();
		left.beginFill(color, alpha);
		left.drawRect(0, y, x, sh - y);
		left.endFill();
		this.addChild(left);

		let right = new engine.Shape();
		right.beginFill(color, alpha);
		right.drawRect(x + w, y, sw - x - w, sh - y);
		right.endFill();
		this.addChild(right);

		let offsetToMask = config.text.offsetToMask;
		let label = new engine.Label();
		label.text = props['guideText' + index];//config.text.str;
		label.size = 24;
		label.fillColor = "rgba(255,255,255,1)";
		label.x = mask.x + (w - label.width) / 2;
		label.y = offsetToMask.y + mask.y;
		this.addChild(label);


		if (index == 0) {
			let left = new engine.Sprite(getTexture("93992a62-e3c4-46d5-99f4-f7ba35fe4f4f"));
			left.x = x1 + 200;
			left.y = y1 - left.height / 2;
			this.addChild(left);

			let right = new engine.Sprite(getTexture("93992a62-e3c4-46d5-99f4-f7ba35fe4f4f"));
			right.x = x1 - 200;
			right.scaleX = -1;
			right.y = y1 - right.height / 2;
			this.addChild(right);
		}

		if (label.x < padding) {
			label.x = padding;
		} else if (label.x + label.width > 750 - padding) {
			label.x = 750 - label.width - padding;
		}

		this.addEventListener(engine.MouseEvent.MOUSE_DOWN, () => {
			this.onClick && this.onClick(this);
		}, this);
	}

	onClick: (context: GuideMask) => void;
}