import GameObject from "./GameObject";
import Collider, {RectCollider, ColliderGroup} from "../Phycics/Collider";
import {MConst} from "../Global/MConst";
import Bullet, {BulletGroup} from "./Bullet";
import SoundMgr from "../Mgr/SoundMgr";
import MTimer from "../Global/MTimer";
import {props} from "../../props";
import {DataMgr} from "../Mgr/DataMgr";
import {clamp, getTexture} from "../utils";


export default class Car extends GameObject {
	private imgParticel: engine.Sprite = null;
	private fireTimer: number = null;
	public touchWall: 1 | -1 | 0 = 0;
	public onDied: () => void;
	private isDied: boolean = false;
	private fireParticleTimer = 0;
	private invincible = false;

	/**每排子弹的个数 */
	private rowBulletNum: number = 1;
	private fireSpeed: number = MConst.BulletFireSpeed.min;
	private collider: RectCollider;

	constructor() {
		super();
		// this.x = 124;
		// this.y = 145;

		const {carCollidePaddingX, carCollidePaddingY} = props;

		let sprite = new engine.Sprite(getTexture("ddf5128e-be66-4c00-8505-e4167aac37bc"));
		sprite.x = 0;
		sprite.y = 16;
		this.addChild(sprite);
		let particle = new engine.Sprite(getTexture("d8daa113-0d75-4139-9e81-c54b7522c890"));
		particle.x = (sprite.width - particle.width) / 2;
		particle.y = 0;
		this.addChild(particle);
		this.imgParticel = particle;
		MTimer.onFrame("Car", this.onUpdate, this);
		let collider = this.collider = this.addComponent<RectCollider>(RectCollider);
		collider.setData(carCollidePaddingX, carCollidePaddingY, sprite.width - carCollidePaddingX * 2, sprite.height - carCollidePaddingY * 2);
		collider.group = ColliderGroup.Car;
	}

	/* private createPart(source: string, x: number, y: number) {
			let bitmap = new engine.Image(getTexture(source) as engine.Texture);
			bitmap.x = x;
			bitmap.y = y;
			this.addChild(bitmap);
			return bitmap;
	} */

	private fire() {
		// return;
		SoundMgr.instance.playEffect("shoot");
		new BulletGroup(new engine.Point(this.x + this.width / 2, this.y), this.rowBulletNum);
	}

	private die() {
		if (this.invincible) return;

		if (this.isDied) return;
		this.isDied = true;

		this.onDied && this.onDied();
	}

	onCollisionEnter(other: Collider) {
		if (other.group == ColliderGroup.Ball) {
			this.die();
		}

		if (other.group == ColliderGroup.Wall) {
			this.touchWall = other.owner.x < 0 ? 1 : -1;

		}
	}

	onCollisionStay(other: Collider) {
		if (other.group == ColliderGroup.Ball) {
			this.die();
		}

		if (other.group == ColliderGroup.Wall) {
			this.touchWall = other.owner.x < 0 ? 1 : -1;

		}
	}

	private onceBlink() {
		engine.Tween.get(this)
			.to({alpha: 0}, 1)
			.wait(100)
			.to({alpha: 1}, 1)
			.wait(100)
			.call(() => {
				this.onceBlink();
			});
	}

	revive() {
		this.invincible = true;
		this.isDied = false;
		engine.Tween.removeTweens(this);
		this.onceBlink();
		MTimer.setFrameTimer(MConst.ReviveInvincibleDuration * 60, () => {
			//无敌结束
			this.invincible = false;
			this.alpha = 1;
			engine.Tween.removeTweens(this);
		});
	}

	move(deltaX: number) {
		if (this.touchWall == 1 && deltaX <= 0) {
			return;
		} else if (this.touchWall == -1 && deltaX >= 0) {
			return;
		}

		const {carCollidePaddingX} = props;
		const {x, width} = this.collider.rect;
		this.x = Math.max(-x, Math.min(750 - width - carCollidePaddingX, this.x + deltaX))
		//this.x += deltaX;
	}

	onCollisionExit(other: Collider) {
		if (other.group == ColliderGroup.Wall) {
			this.touchWall = 0;
		}
	}

	private onUpdate() {
		if (DataMgr.game.pause) return;

		const score = DataMgr.game.bulletScore;
		//更新开火速度
		if (score <= 20) {
			const max = MConst.BulletFireSpeed.max;
			const min = MConst.BulletFireSpeed.min;
			this.fireSpeed = min + (max - min) * (score / 20);
		} else {
			this.fireSpeed = MConst.BulletFireSpeed.max;
		}
		//更新子弹排数
		this.rowBulletNum = Math.ceil((clamp(score, 15, 140) / 2) / 10);

		//开火计时流逝
		this.fireTimer += 1 * MTimer.dtFactor;

		if (this.fireTimer >= 60 / this.fireSpeed) {
			this.fire();
			this.fireTimer = 0;
		}
		if (this.fireParticleTimer % 3 == 0) {
			this.imgParticel.visible = !this.imgParticel.visible;
		}

		this.fireParticleTimer++;
	}
}