

import { getTextureByName } from "../game/utils";
import LabelType from "../game/LabelType";
import MovieClip from "./MovieClip";

export default class BaseItem extends engine.Sprite {
    _mc: MovieClip;
    type: LabelType;
    constructor(mc: MovieClip, type?: LabelType) {
        super();
        this.type = type;
        this._mc = mc;
        const bubble: engine.Texture = getTextureByName('bubble');
        const bubblePic = new engine.Sprite(bubble);
        bubblePic.anchorTexture.set(0.5,0.5);
        //bubblePic.anchorX = 76;
        //bubblePic.anchorY = 78;
        //bubblePic.x = bubblePic.x-76
        //bubblePic.y = bubblePic.y-78

        this._mc.anchorTexture.set(0.5,0.5)
        this._mc.x = bubblePic.x/4;
        this._mc.y = bubblePic.y/4;

        this.addChild(bubblePic);                                                                                                                                  
        this.addChild(this._mc);
    }

    get mc() { return this._mc; }
}