export default (view: engine.DisplayObject,count=2,strength=10) => {
    return new Promise((r) => {
        const pos = [
            { x: strength, y: 0 },
            { x: 0, y: -strength },
            { x: -strength, y: 0 },
            { x: 0, y: strength },
            { x: 0, y: 0 },
        ];

        let list = [];
        for (let i = 0; i < count; i++) {
            list = list.concat(pos);
        }

        const x0 = view.x;
        const y0 = view.y;
        let counter = list.length;
        for (let i = 0; i < list.length; i++) {
            const element = list[i];
            setTimeout(() => {
                view.x = element.x + x0;
                view.y = element.y + y0;
                counter--;
                if (counter == 0) {
                    view.x = x0;
                    view.y = y0;
                    r();
                };
            }, 1000 / 60 * i);
        }
    });

}
