import BaseItem from "../../physics/BaseItem";
import LabelType from "../LabelType";
import MovieClip from "../../physics/MovieClip";
import { getTextureByName } from "../utils";
import { getJosnData, getJsonAsset } from "../JsonTools";
import { createTextureSheet } from "../createTextureSheet";

const createGift = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    let josnData = getJosnData('gift');
    if(!josnData){
        getJsonAsset('gift');
        josnData = getJosnData('gift');
    }
    const texture = createTextureSheet(getTextureByName('gift').baseTexture,josnData);
    
    const animation = createMovieClip(texture, 0.6);
    const baseItem = new BaseItem(animation,LabelType.gift);
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createMovieClip = (spritesheet, scale = 1) => {
    const list = ['gift1.png', 'gift2.png', 'gift3.png', 'gift4.png', 'gift5.png', 'gift6.png', 'gift7.png', 'gift8.png', 'gift9.png', 'gift10.png'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 5,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createGift