import BaseItem from "../../physics/BaseItem";
import LabelType from "../LabelType";
import MovieClip from "../../physics/MovieClip";
import { getTextureByName } from "../utils";
import { getJosnData, getJsonAsset } from "../JsonTools";
import { createTextureSheet } from "../createTextureSheet";

const createEgg = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    let josnData = getJosnData('egg');
    if(!josnData){
        getJsonAsset('gift');
        josnData = getJosnData('egg');
    }
    const texture = createTextureSheet(getTextureByName('egg').baseTexture,josnData);
    
    const animation = createMovieClip(texture, 0.6);
    const baseItem = new BaseItem(animation,LabelType.egg);
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createMovieClip = (spritesheet, scale = 1) => {
    const list = ['egg1.png', 'egg2.png', 'egg3.png', 'egg4.png', 'egg5.png', 'egg6.png', 'egg7.png', 'egg8.png', 'egg9.png'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 5,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createEgg