import BaseItem from "../../physics/BaseItem";
import LabelType from "../LabelType";
import MovieClip from "../../physics/MovieClip";
import { getTextureByName } from "../utils";
import { getJosnData, getJsonAsset } from "../JsonTools";
import { createTextureSheet } from "../createTextureSheet";

const createCoin = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    let josnData = getJosnData('coin');
    if(!josnData){
        getJsonAsset('coin');
        josnData = getJosnData('coin');
    }
    const texture = createTextureSheet(getTextureByName('coin').baseTexture,josnData);
    
    const animation = createMovieClip(texture, 0.6);
    const baseItem = new BaseItem(animation,LabelType.coin);
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createMovieClip = (spritesheet, scale = 1) => {
    const list = ['coin1.png', 'coin2.png', 'coin3.png', 'coin4.png', 'coin5.png', 'coin6.png', 'coin7.png', 'coin8.png'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 6,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createCoin