import BaseItem from "../../physics/BaseItem";
import { getJosnData, getJsonAsset } from "../JsonTools";
import { createTextureSheet } from "../createTextureSheet";
import { getTextureByName } from "../utils";
import LabelType from "../LabelType";
import MovieClip from "../../physics/MovieClip";


const createCandy = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    let josnData = getJosnData('candy');
    if(!josnData){
        getJsonAsset('candy');
        josnData = getJosnData('candy');
    }
    const boomTexture = createTextureSheet(getTextureByName('candy').baseTexture,josnData);
    //炸弹纹理种炸弹的尺寸默认58，不进行缩放
    //气泡和炸弹的比例为100/58
    const animation = createMovieClip(boomTexture);
    const baseItem = new BaseItem(animation, LabelType.candy);
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createMovieClip = (spritesheet, scale = 1) => {
    const list = ['candy1.png', 'candy2.png', 'candy3.png', 'candy4.png', 'candy5.png', 'candy6.png', 'candy7.png', 'candy8.png'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 6,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createCandy