import BaseItem from "../../physics/BaseItem";
import { getJosnData, getJsonAsset } from "../JsonTools";
import { createTextureSheet } from "../createTextureSheet";
import { getTextureByName } from "../utils";
import LabelType from "../LabelType";
import MovieClip from "../../physics/MovieClip";


const createBoom = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    let josnData = getJosnData('boom');
    if(!josnData){
        getJsonAsset('boom');
        josnData = getJosnData('boom');
    }
    const boomTexture = createTextureSheet(getTextureByName('boom').baseTexture,josnData);
    //炸弹纹理种炸弹的尺寸默认58，不进行缩放
    //气泡和炸弹的比例为100/58
    const animation = createMovieClip(boomTexture);
    const baseItem = new BaseItem(animation, LabelType.boom);
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createMovieClip = (spritesheet, scale = 1) => {
    const list = ['boom1.png', 'boom2.png', 'boom3.png', 'boom4.png', 'boom5.png', 'boom6.png', 'boom7.png', 'boom8.png', 'boom9.png', 'boom10.png'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 5,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createBoom