import GameView from "./GameView";
import LabelType from "./LabelType";
import createItem from "./createItem";
import { award, awardMask } from "./collisionConfig";
import { getCurrentItems, getScore } from "./goldData";

export const createNewBubble = (_this: GameView, type: LabelType) => {
    createBubble(_this, type, 750 / 2, 450, { x: 0, y: 0 },0.001*10);
}
const createBubble = (_this: GameView, type: LabelType, x: number, y: number, force = { x: 0, y: 0 }, density = 0.001) => {
    let scale;
    const size = random(85, 100);
    const maxsize = 100;
    scale = size / maxsize;
    const baseItem = createItem(scale, type);

    let angle;
    angle = 0;
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    //刚体和贴图尺寸比为1:1.12
    _this._egretRender.circle(x, y, (size - 17) / 2, baseItem,
        {
            frictionAir: 0,
            collisionFilter: { group: award, category: award, mask: awardMask },
            angle: angle,
            label: baseItem.type,
            friction: 0,
            force: force,
            density: density
        });
}
const random = (start, end) => {
    const n = end - start; 
    return Math.random() * n + start;
} 

export const rollbackIcon = (nums: number, _this:GameView) => {
    const startY = 370;
    const startX = Math.random() > .5 ? 150 : 750 - 150;
    createBubble(_this, LabelType.boom, startX, startY);

    let count = 0;
    const coinsFall = setInterval(() => {
        if (count <= nums - 1) {
            const startX = Math.random() > .5 ? 150 : 750 - 150;
            createBubble(_this, LabelType.coin, startX, startY)
            count++;
        } else {
            //结束
        }
    }, 100);
}
export default (_this: GameView) => {
    const score = getScore();
    const items = getCurrentItems();//[[LabelType.boom, 1], [LabelType.coin, 5]]
    const list = [];
    for (const item of items) {
        const type = item[0];
        let nums = item[1];
        if (type == LabelType.coin)
            nums = nums - score;
        for (let i = 0; i < nums; i++) {
            list.push(type);
        }
    }
    let count = 0;
    const countMax = 1;
    const coinsFall = setInterval(() => {
        if (count <= list.length - 1) {
            const type = list[count];
            createBubble(_this, type,375 + Math.random() * 200-100 , 400 + 200 +200)
            count++;
        } else {
            //结束
        }
    }, 100);
}