


import LabelType from "./LabelType";
import createCoin from "./item/createCoin";
import createBoom from "./item/createBoom";
import createGift from "./item/createGift";
import createCandy from "./item/createCandy";
import createEgg from "./item/createEgg";

const createItem = (scale, type: LabelType) => {
    const funcs = {
        'boom': createBoom,
        'gift': createGift,
        'candy': createCandy,
        'egg': createEgg,
        'coin': createCoin
    };
    const func = funcs[type];
    
    return func(scale);
}
export default createItem