
import GameView from "./GameView";

export default (that: GameView) => {

    const createShape = () => {
        const shape = new engine.Shape();
        shape.beginFill(0, .6);
        shape.drawCircle(0, 0, that._leftBtn.width / 2);
        shape.endFill();
        return shape
    }

    [that._leftBtn, that._rightBtn].forEach(btn => {
        btn.addEventListener(engine.MouseEvent.MOUSE_DOWN, (e: engine.MouseEvent) => {
            const btn = e.target;
            engine.Tween.removeTweens(btn);
            engine.Tween.get(btn)
            .to({scaleY:0.9},200)
        }, that);
    });

    [that._leftBtn, that._rightBtn].forEach(btn => {
        btn.addEventListener(engine.MouseEvent.MOUSE_UP, (e: engine.MouseEvent) => {
            const btn = e.target;
            engine.Tween.removeTweens(btn);
            engine.Tween.get(btn)
            .to({scaleX:1,scaleY:1},200)
        }, that);
    });

    [that._leftBtn, that._rightBtn].forEach(btn => {
        btn.addEventListener(engine.MouseEvent.MOUSE_OUT, (e: engine.MouseEvent) => {
            const btn = e.target;
            engine.Tween.removeTweens(btn);
            engine.Tween.get(btn)
            .to({scaleX:1,scaleY:1},200)
        }, that);
    });

    // this['rightBtn'];
    const shapeLeft = createShape();
    shapeLeft.x = that._leftBtn.width/2
    shapeLeft.y = that._leftBtn.height/2
    that._leftBtn.addChild(shapeLeft);
    //shapeLeft.x = that._leftBtn.x;
    //shapeLeft.y = that._leftBtn.y;
    //that._leftBtn.mask = shapeLeft;

    const shapeR = createShape();
    shapeR.x = that._rightBtn.width/2
    shapeR.y = that._rightBtn.height/2
    that._rightBtn.addChild(shapeR);
    // shapeR.x = that._rightBtn.x;
    // shapeR.y = that._rightBtn.y;
    // that._rightBtn.mask = shapeR;

    shapeLeft.alpha = shapeR.alpha = 0;
}

