import { wall, wallMask, basket, basketMask } from "./collisionConfig";
import GameView from "./GameView";

const createBox = (_this:GameView) => {
    //202
    //385 168 640 201 695 528 644 866 392 907 109 868 57 546 118 206 0 206 0 1624 750 1624 750 0
    //385 370 630 380 670 728 620 1080 370 1100 109 1090 57 728 108 370 0 370 0 1624 750 1624 750 0
    const path1 = Matter.Vertices.fromPath('385 370 630 380 670 728 620 1080 370 1100 109 1090 57 728 108 370 0 370 0 1624 750 1624 750 0', null);
    //430, 717
    //430,920
    const body = Matter.Bodies.fromVertices(400, 880, [path1], { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } }, true);
    Matter.World.add(_this._engine.world, body);
    //118 206 385 168 385 100
    //108 370 385 370 385 300
    const path2 = Matter.Vertices.fromPath('108 370 385 370 385 300', null);
    //425 - 10 - 100 - 10 - 10 + 1, 30 + 100 + 10 + 10 + 6
    //296, 365
    const body2 = Matter.Bodies.fromVertices(296, 365, [path2], { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } }, true);
    Matter.World.add(_this._engine.world, body2);
    //290 432 324 476 326 476 313 432
    //290 560 324 600 326 600 313 565
    const basketpath1 = Matter.Vertices.fromPath('290 560 324 600 326 600 313 565', null);
    //311 - 3 - 8 + 2+3, 452 - 5
    //305, 575
    const basketbody1 = Matter.Bodies.fromVertices(305, 575, [basketpath1], { isStatic: true, friction: 0, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
    Matter.World.add(_this._engine.world, basketbody1);
    //479 435 443 481 441 481 456 435
    //465 563 443 605 441 605 456 560
    const basketpath2 = Matter.Vertices.fromPath('465 563 443 605 441 605 456 560', null);
    //449 + 3 + 8 - 2 - 2-3, 452 - 5
    //453, 570
    const basketbody2 = Matter.Bodies.fromVertices(453, 570, [basketpath2], { isStatic: true, friction: 0, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
    Matter.World.add(_this._engine.world, basketbody2);
    //311 - 3 - 8 + 2 - 5, 427
    //285, 560 
    const basketLeft = Matter.Bodies.circle(285, 560 , 12, { isStatic: true, friction: 0, collisionFilter: { group: basket, category: basket, mask: basketMask } })
    Matter.World.add(_this._engine.world, basketLeft);
    //456 + 5, 427
    //461, 560
    const basketRight = Matter.Bodies.circle(461, 560, 12, { isStatic: true, friction: 0, collisionFilter: { group: basket, category: basket, mask: basketMask } })
    Matter.World.add(_this._engine.world, basketRight);

    
    const w = 100;
    const h = 50;
    //153 + w / 2, 833 + h / 2
    //180 1080
    const rect = _this._egretRender.rectangle(180, 1080, w, h, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
    //553 - 10 - 30 - 5 + w / 2, 833 + h / 2
    //560 1080
    const rect2 = _this._egretRender.rectangle(560, 1080, w, h, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });

    const w2 = 300;
    const h2 = 10;
    //375, 873 + h2 / 2
    //375 1100
    const rect3 = _this._egretRender.rectangle(375, 1100, w2, h2, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
}

export default createBox