
let josnData: {
    [name: string]: any
} = {};

export function getJsonAsset(name: string) {
    let config = engine.getAssetByName(name+'_json');
    let tmpJosnData = engine.globalLoader.get(config.uuid);
    if(tmpJosnData){
        josnData[name] = convert(tmpJosnData);
    }
}

export function convert(data){
    let frames = data.frames;
    let jsonName = data.file.split('.')[0]
    var obj = {};

    for (var key in frames) {
        let f = frames[key];
        obj[jsonName + key + ".png"] = {
            "x": f.x,
            "y": f.y,
            "w": f.w,
            "h": f.h,
            "ox": f.offX,
            "oy": f.offY,
            "sw": f.sourceW,
            "sh": f.sourceH,
            "ro": false,
        }
    }
    return obj||null;
}

export function getJosnData(jsonName:string) {
    return josnData[jsonName] || null;
}